% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wprime.R
\name{Wprime}
\alias{Wprime}
\alias{trackeRWprime}
\alias{Based}
\alias{on}
\alias{the}
\alias{critical}
\alias{power}
\alias{model}
\alias{for}
\alias{cycling}
\alias{(Monod}
\alias{and}
\alias{Scherrer,}
\alias{1965),}
\alias{W'}
\alias{(read}
\alias{W}
\alias{prime)}
\alias{describes}
\alias{finite}
\alias{work}
\alias{capacity}
\alias{above}
\alias{(Skiba}
\alias{et}
\alias{al.,}
\alias{2012).}
\alias{While}
\alias{is}
\alias{depleted}
\alias{during}
\alias{exercise}
\alias{power,}
\alias{it}
\alias{replenished}
\alias{below}
\alias{power.}
\alias{Thus,}
\alias{of}
\alias{interest}
\alias{how}
\alias{much}
\alias{this}
\alias{has}
\alias{been}
\alias{not}
\alias{yet}
\alias{replinished}
\alias{again,}
\alias{named}
\alias{expended,}
\alias{or}
\alias{still}
\alias{available,}
\alias{balance.}
\alias{This}
\alias{principal}
\alias{applied}
\alias{to}
\alias{runners}
\alias{by}
\alias{subsituting}
\alias{with}
\alias{speed}
\alias{speed,}
\alias{respectively}
\title{W': work capacity above critical power/speed.}
\usage{
Wprime(object, session = NULL, quantity = c("expended", "balance"), w0,
  cp, version = c("2015", "2012"), meanRecoveryPower = FALSE,
  parallel = FALSE, ...)
}
\arguments{
\item{object}{A \code{\link{trackeRdata}} object.}

\item{session}{A numeric vector of the sessions to be used,
defaults to all sessions.}

\item{quantity}{Should W' \code{'expended'} or W' \code{'balance'}
be returned?}

\item{w0}{Inital capacity of W', as calculated based on the
critical power model by Monod and Scherrer (1965).}

\item{cp}{Critical power/speed, i.e., the power/speed which can be
maintained for longer period of time.}

\item{version}{How should W' be replenished? Options include
\code{'2015'} and \code{'2012'} for the versions presented in
Skiba et al. (2015) and Skiba et al. (2012), respectively. See
Details.}

\item{meanRecoveryPower}{Should the mean of all power outputs below
critical power be used as recovery power? See Details.}

\item{parallel}{Logical. Should computation be carried out in
parallel? If \code{TRUE} computation is performed in parallel
using the backend provided to \code{\link{foreach}}. Default is
\code{FALSE}.}

\item{...}{Currently not used.}
}
\value{
An object of class \code{trackeRWprime}.
}
\description{
W': work capacity above critical power/speed.
}
\details{
#' Skiba et al. (2015) and Skiba et al. (2012) both describe an
exponential decay of \eqn{W'} expended over an interval
\eqn{[t_{i-1}, t_i)} if the power output during this interval is
below critical power:

\deqn{W_exp (t_i) = W_exp(t_{i-1}) * exp(nu * (t_i - t_{i-1}))}

However, the factor nu differs: Skiba et al. (2012) describe it as
\eqn{1/\tau} with \eqn{\tau} estimated as

\deqn{tau = 546 * exp(-0.01 * (CP - P_i)) + 316}

Skiba et al. (2015) use \eqn{(P_i - CP) / W'_0}.  Skiba et
al. (2012) and Skiba et al. (2015) employ a constant recovery power
(calculated as the mean over all power outputs below critical
power). This rationale can be applied by setting the argument
\code{meanRecoveryPower} to \code{TRUE}. Note that this uses
information from all observations with a power output below
critical power, not just those prior to the current time point.
}
\examples{
\dontrun{
data('runs', package = 'trackeR')
wexp <- Wprime(runs, session = c(11,13), cp = 4, version = '2012')
plot(wexp)
}
}
\references{
Monod H, Scherrer J (1965). 'The Work Capacity of a Synergic
Muscular Group.' Ergonomics, 8(3), 329--338.

Skiba PF, Chidnok W, Vanhatalo A, Jones AM (2012). 'Modeling the
Expenditure and Reconstitution of Work Capacity above Critical
Power.' Medicine & Science in Sports & Exercise, 44(8), 1526--1532.

Skiba PF, Fulford J, Clarke DC, Vanhatalo A, Jones AM
(2015). 'Intramuscular Determinants of the Abilility to Recover
Work Capacity above Critical Power.' European Journal of Applied
Physiology, 115(4), 703--713.
}
