% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.R
\name{missing_t}
\alias{missing_t}
\title{Find Missing Data in a Track Table}
\usage{
missing_t(x, begin = NULL, end = NULL, step = NULL)
}
\arguments{
\item{x}{A \code{\link{track}} table as produced by the \code{\link{track}}
function.}

\item{begin}{A full timestamp (date+time) in \code{\link{POSIXct}} format
corresponding to the time from which the missing data should be looked for.
If not set, the first timestamp of the track table will be used.}

\item{end}{A full timestamp (date+time) in \code{\link{POSIXct}} format
corresponding to the time until which the missing data should be looked for.
If not set, the last timestamp of the track table will be used.}

\item{step}{A \code{\link{difftime}} object representing the expected time
between two consecutive locations of the trajectory. If not set, it is set
to the most common time difference between successive locations in \code{x}.}
}
\value{
A data frame/table/tibble with the missing timestamps for each
 individual track in \code{x}. If no missing data are detected, the function
 returns \code{NULL}.
}
\description{
This function attempts to automatically detect missing data (for
 instance due to writing errors) in \code{\link{track}} tables.
}
\examples{
# Create data set with missing timestamps
data(short_tracks)
t_df <- track(x = short_tracks$x, y = short_tracks$y, t = short_tracks$t,
              id = short_tracks$id, proj = "+proj=longlat",
              tz = "Africa/Windhoek", table = "df")
t_df <- t_df[-c(10, 100), ]

# Find missing data
missing <- missing_t(t_df)

}
\seealso{
\code{\link{track}}
}
\author{
Simon Garnier, \email{garnier@njit.edu}
}
