% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_beast_output_files.R
\name{parse_beast_output_files}
\alias{parse_beast_output_files}
\title{Parse all BEAST2 output files}
\usage{
parse_beast_output_files(log_filename, trees_filenames, state_filename)
}
\arguments{
\item{log_filename}{deprecated name
of the BEAST2 tracelog \code{.log} output file.
Use \code{tracelog_filename} instead}

\item{trees_filenames}{the names of one or more a BEAST2
posterior \code{.trees} file.
Each \code{.trees} file can be read using \link{parse_beast_trees}}

\item{state_filename}{name of the BEAST2 state \code{.xml.state} output file}
}
\value{
a list with the following elements:\cr
  \itemize{
    item{\code{estimates}: parameter estimates}
    item{
      \code{[alignment_id]_trees}: the phylogenies in the
      BEAST2 posterior. \code{[alignment_id]} is the ID
      of the alignment.
    }
    item{\code{operators}: the BEAST2 MCMC operator
      acceptances
    }
  }
}
\description{
Parse all BEAST2 output files
}
\examples{
trees_filenames <- get_tracerer_path("beast2_example_output.trees")
log_filename <- get_tracerer_path("beast2_example_output.log")
state_filename <- get_tracerer_path("beast2_example_output.xml.state")
parse_beast_output_files(
  log_filename = log_filename,
  trees_filenames = trees_filenames,
  state_filename = state_filename
)
}
\seealso{
Use \code{\link{remove_burn_ins}} to remove the burn-in from
  \code{out$estimates}
}
\author{
Richèl J.C. Bilderbeek
}
