% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_summary_stats.R
\name{calc_summary_stats_trace}
\alias{calc_summary_stats_trace}
\title{Calculates the Effective Sample Sizes of one estimated variable's trace.}
\usage{
calc_summary_stats_trace(trace, sample_interval)
}
\arguments{
\item{trace}{a numeric vector of values. Assumes the burn-in
is removed.}

\item{sample_interval}{the interval in timesteps between samples}
}
\value{
the effective sample sizes
}
\description{
Calculates the Effective Sample Sizes of one estimated variable's trace.
}
\examples{
estimates_all <- parse_beast_tracelog_file(
  get_tracerer_path("beast2_example_output.log")
)
estimates <- remove_burn_ins(estimates_all, burn_in_fraction = 0.1)

calc_summary_stats_trace(
  estimates$posterior,
  sample_interval = 1000
)
}
\seealso{
Use \code{\link{remove_burn_in}} to remove the burn-in
  of a trace
}
\author{
Richèl J.C. Bilderbeek
}
