% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional.R
\name{functional_griffinlim}
\alias{functional_griffinlim}
\title{Griffin-Lim Transformation (functional)}
\usage{
functional_griffinlim(
  specgram,
  window,
  n_fft,
  hop_length,
  win_length,
  power,
  normalized,
  n_iter,
  momentum,
  length,
  rand_init
)
}
\arguments{
\item{specgram}{(Tensor): A magnitude-only STFT spectrogram of dimension (..., freq, frames)
where freq is \code{n_fft \%/\% 2 + 1}.}

\item{window}{(Tensor): Window tensor that is applied/multiplied to each frame/window}

\item{n_fft}{(int): Size of FFT, creates \code{n_fft \%/\% 2 + 1} bins}

\item{hop_length}{(int): Length of hop between STFT windows.}

\item{win_length}{(int): Window size.}

\item{power}{(float): Exponent for the magnitude spectrogram,
(must be > 0) e.g., 1 for energy, 2 for power, etc.}

\item{normalized}{(bool): Whether to normalize by magnitude after stft.}

\item{n_iter}{(int): Number of iteration for phase recovery process.}

\item{momentum}{(float): The momentum parameter for fast Griffin-Lim.
Setting this to 0 recovers the original Griffin-Lim method.
Values near 1 can lead to faster convergence, but above 1 may not converge.}

\item{length}{(int or NULL): Array length of the expected output.}

\item{rand_init}{(bool): Initializes phase randomly if TRUE, to zero otherwise.}
}
\value{
\code{tensor}: waveform of (..., time), where time equals the \code{length} parameter if given.
}
\description{
Compute waveform from a linear scale magnitude spectrogram using the Griffin-Lim transformation.
Implementation ported from \code{librosa}.
}
