% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_conv1d}
\alias{torch_conv1d}
\title{Conv1d}
\usage{
torch_conv1d(
  input,
  weight,
  bias = list(),
  stride = 1L,
  padding = 0L,
  dilation = 1L,
  groups = 1L
)
}
\arguments{
\item{input}{input tensor of shape \eqn{(\mbox{minibatch} , \mbox{in\_channels} , iW)}}

\item{weight}{filters of shape \eqn{(\mbox{out\_channels} , \frac{\mbox{in\_channels}}{\mbox{groups}} , kW)}}

\item{bias}{optional bias of shape \eqn{(\mbox{out\_channels})}. Default: \code{NULL}}

\item{stride}{the stride of the convolving kernel. Can be a single number or      a one-element tuple \verb{(sW,)}. Default: 1}

\item{padding}{implicit paddings on both sides of the input. Can be a      single number or a one-element tuple \verb{(padW,)}. Default: 0}

\item{dilation}{the spacing between kernel elements. Can be a single number or      a one-element tuple \verb{(dW,)}. Default: 1}

\item{groups}{split input into groups, \eqn{\mbox{in\_channels}} should be divisible by      the number of groups. Default: 1}
}
\description{
Conv1d
}
\section{conv1d(input, weight, bias=NULL, stride=1, padding=0, dilation=1, groups=1) -> Tensor }{


Applies a 1D convolution over an input signal composed of several input
planes.

See \code{\link[=nn_conv1d]{nn_conv1d()}} for details and output shape.
}

\examples{
if (torch_is_installed()) {

filters = torch_randn(c(33, 16, 3))
inputs = torch_randn(c(20, 16, 50))
nnf_conv1d(inputs, filters)
}
}
