% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/wrapers.R
\name{torch_triu_indices}
\alias{torch_triu_indices}
\title{Triu_indices}
\usage{
torch_triu_indices(
  row,
  col,
  offset = 0,
  dtype = torch_long(),
  device = "cpu",
  layout = torch_strided()
)
}
\arguments{
\item{row}{(\code{int}) number of rows in the 2-D matrix.}

\item{col}{(\code{int}) number of columns in the 2-D matrix.}

\item{offset}{(\code{int}) diagonal offset from the main diagonal.        Default: if not provided, 0.}

\item{dtype}{(\code{torch.dtype}, optional) the desired data type of returned tensor.        Default: if \code{NULL}, \code{torch_long}.}

\item{device}{(\code{torch.device}, optional) the desired device of returned tensor.        Default: if \code{NULL}, uses the current device for the default tensor type        (see \code{torch_set_default_tensor_type}). \code{device} will be the CPU        for CPU tensor types and the current CUDA device for CUDA tensor types.}

\item{layout}{(\code{torch.layout}, optional) currently only support \code{torch_strided}.}
}
\description{
Triu_indices
}
\note{
\preformatted{When running on CUDA, `row * col` must be less than \eqn{2^{59}} to
prevent overflow during calculation.
}
}
\section{triu_indices(row, col, offset=0, dtype=torch.long, device='cpu', layout=torch.strided) -> Tensor }{


Returns the indices of the upper triangular part of a \code{row} by
\code{col} matrix in a 2-by-N Tensor, where the first row contains row
coordinates of all indices and the second row contains column coordinates.
Indices are ordered based on rows and then columns.

The upper triangular part of the matrix is defined as the elements on and
above the diagonal.

The argument \code{offset} controls which diagonal to consider. If
\code{offset} = 0, all elements on and above the main diagonal are
retained. A positive value excludes just as many diagonals above the main
diagonal, and similarly a negative value includes just as many diagonals below
the main diagonal. The main diagonal are the set of indices
\eqn{\lbrace (i, i) \rbrace} for \eqn{i \in [0, \min\{d_{1}, d_{2}\} - 1]}
where \eqn{d_{1}, d_{2}} are the dimensions of the matrix.
}

\examples{
if (torch_is_installed()) {
\dontrun{
a = torch_triu_indices(3, 3)
a
a = torch_triu_indices(4, 3, -1)
a
a = torch_triu_indices(4, 3, 1)
a
}
}
}
