% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim-lr_scheduler.R
\name{lr_lambda}
\alias{lr_lambda}
\title{Sets the learning rate of each parameter group to the initial lr
times a given function. When last_epoch=-1, sets initial lr as lr.}
\usage{
lr_lambda(optimizer, lr_lambda, last_epoch = -1, verbose = FALSE)
}
\arguments{
\item{optimizer}{(Optimizer): Wrapped optimizer.}

\item{lr_lambda}{(function or list): A function which computes a multiplicative
factor given an integer parameter epoch, or a list of such
functions, one for each group in optimizer.param_groups.}

\item{last_epoch}{(int): The index of last epoch. Default: -1.}

\item{verbose}{(bool): If \code{TRUE}, prints a message to stdout for
each update. Default: \code{FALSE}.}
}
\description{
Sets the learning rate of each parameter group to the initial lr
times a given function. When last_epoch=-1, sets initial lr as lr.
}
\examples{
if (torch_is_installed()) {
# Assuming optimizer has two groups.
lambda1 <- function(epoch) epoch \%/\% 30
lambda2 <- function(epoch) 0.95^epoch
\dontrun{
scheduler <- lr_lambda(optimizer, lr_lambda = list(lambda1, lambda2))
for (epoch in 1:100) {
  train(...)
  validate(...)
  scheduler$step()
}
}

}
}
