% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linalg.R
\name{linalg_pinv}
\alias{linalg_pinv}
\title{Computes the pseudoinverse (Moore-Penrose inverse) of a matrix.}
\usage{
linalg_pinv(A, rcond = NULL, hermitian = FALSE, atol = NULL, rtol = NULL)
}
\arguments{
\item{A}{(Tensor): tensor of shape \verb{(*, m, n)} where \code{*} is zero or more batch dimensions.}

\item{rcond}{(float or Tensor, optional): the tolerance value to determine when is a singular value zero
If it is a \code{torch_Tensor}, its shape must be
broadcastable to that of the singular values of
\code{A} as returned by \code{\link[=linalg_svd]{linalg_svd()}}.
Alias for \code{rtol}.
Default: \code{0}.}

\item{hermitian}{(bool, optional): indicates whether \code{A} is Hermitian if complex
or symmetric if real. Default: \code{FALSE}.}

\item{atol}{the absolute tolerance value. When \code{NULL} it’s considered to be zero.}

\item{rtol}{the relative tolerance value. See above for the value it takes when \code{NULL}.}
}
\description{
The pseudoinverse may be \verb{defined algebraically}_
but it is more computationally convenient to understand it \verb{through the SVD}_
Supports input of float, double, cfloat and cdouble dtypes.
Also supports batches of matrices, and if \code{A} is a batch of matrices then
the output has the same batch dimensions.
}
\details{
If \code{hermitian= TRUE}, \code{A} is assumed to be Hermitian if complex or
symmetric if real, but this is not checked internally. Instead, just the lower
triangular part of the matrix is used in the computations.
The singular values (or the norm of the eigenvalues when \code{hermitian= TRUE})
that are below the specified \code{rcond} threshold are treated as zero and discarded
in the computation.
}
\note{
This function uses \code{\link[=linalg_svd]{linalg_svd()}} if \code{hermitian= FALSE} and
\code{\link[=linalg_eigh]{linalg_eigh()}} if \code{hermitian= TRUE}.
For CUDA inputs, this function synchronizes that device with the CPU.

Consider using \code{\link[=linalg_lstsq]{linalg_lstsq()}} if possible for multiplying a matrix on the left by
the pseudoinverse, as \code{linalg_lstsq(A, B)$solution == A$pinv() \%*\% B}

It is always prefered to use \code{\link[=linalg_lstsq]{linalg_lstsq()}} when possible, as it is faster and more
numerically stable than computing the pseudoinverse explicitly.
}
\examples{
if (torch_is_installed()) {
A <- torch_randn(3, 5)
linalg_pinv(A)
}
}
\seealso{
\itemize{
\item \code{\link[=linalg_inv]{linalg_inv()}} computes the inverse of a square matrix.
\item \code{\link[=linalg_lstsq]{linalg_lstsq()}} computes \code{A$pinv() \%*\% B} with a
numerically stable algorithm.
}

Other linalg: 
\code{\link{linalg_cholesky_ex}()},
\code{\link{linalg_cholesky}()},
\code{\link{linalg_det}()},
\code{\link{linalg_eigh}()},
\code{\link{linalg_eigvalsh}()},
\code{\link{linalg_eigvals}()},
\code{\link{linalg_eig}()},
\code{\link{linalg_householder_product}()},
\code{\link{linalg_inv_ex}()},
\code{\link{linalg_inv}()},
\code{\link{linalg_lstsq}()},
\code{\link{linalg_matrix_norm}()},
\code{\link{linalg_matrix_power}()},
\code{\link{linalg_matrix_rank}()},
\code{\link{linalg_multi_dot}()},
\code{\link{linalg_norm}()},
\code{\link{linalg_qr}()},
\code{\link{linalg_slogdet}()},
\code{\link{linalg_solve}()},
\code{\link{linalg_svdvals}()},
\code{\link{linalg_svd}()},
\code{\link{linalg_tensorinv}()},
\code{\link{linalg_tensorsolve}()},
\code{\link{linalg_vector_norm}()}
}
\concept{linalg}
