% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-pooling.R
\name{nnf_max_pool3d}
\alias{nnf_max_pool3d}
\title{Max_pool3d}
\usage{
nnf_max_pool3d(
  input,
  kernel_size,
  stride = NULL,
  padding = 0,
  dilation = 1,
  ceil_mode = FALSE,
  return_indices = FALSE
)
}
\arguments{
\item{input}{input tensor (minibatch, in_channels , iT * iH , iW)}

\item{kernel_size}{size of the pooling region. Can be a single number or a
tuple \verb{(kT, kH, kW)}}

\item{stride}{stride of the pooling operation. Can be a single number or a
tuple \verb{(sT, sH, sW)}. Default: \code{kernel_size}}

\item{padding}{implicit zero paddings on both sides of the input. Can be a
single number or a tuple \verb{(padT, padH, padW)}, Default: 0}

\item{dilation}{controls the spacing between the kernel points; also known as
the à trous algorithm.}

\item{ceil_mode}{when True, will use \code{ceil} instead of \code{floor} in the formula
to compute the output shape}

\item{return_indices}{whether to return the indices where the max occurs.}
}
\description{
Applies a 3D max pooling over an input signal composed of several input
planes.
}
