% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_lerp}
\alias{torch_lerp}
\title{Lerp}
\arguments{
\item{input}{(Tensor) the tensor with the starting points}

\item{end}{(Tensor) the tensor with the ending points}

\item{weight}{(float or tensor) the weight for the interpolation formula}

\item{out}{(Tensor, optional) the output tensor.}
}
\description{
Lerp
}
\section{lerp(input, end, weight, out=None) }{


Does a linear interpolation of two tensors \code{start} (given by \code{input}) and \code{end} based
on a scalar or tensor \code{weight} and returns the resulting \code{out} tensor.

\deqn{
    \mbox{out}_i = \mbox{start}_i + \mbox{weight}_i \times (\mbox{end}_i - \mbox{start}_i)
}
The shapes of \code{start} and \code{end} must be
broadcastable . If \code{weight} is a tensor, then
the shapes of \code{weight}, \code{start}, and \code{end} must be broadcastable .
}

\examples{
if (torch_is_installed()) {

start = torch_arange(1., 5.)
end = torch_empty(4)$fill_(10)
start
end
torch_lerp(start, end, 0.5)
torch_lerp(start, end, torch_full_like(start, 0.5))
}
}
