% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_conv_transpose1d}
\alias{torch_conv_transpose1d}
\title{Conv_transpose1d}
\arguments{
\item{input}{NA input tensor of shape \eqn{(\mbox{minibatch} , \mbox{in\_channels} , iW)}}

\item{weight}{NA filters of shape \eqn{(\mbox{in\_channels} , \frac{\mbox{out\_channels}}{\mbox{groups}} , kW)}}

\item{bias}{NA optional bias of shape \eqn{(\mbox{out\_channels})}. Default: None}

\item{stride}{NA the stride of the convolving kernel. Can be a single number or a      tuple \verb{(sW,)}. Default: 1}

\item{padding}{NA \code{dilation * (kernel_size - 1) - padding} zero-padding will be added to both      sides of each dimension in the input. Can be a single number or a tuple      \verb{(padW,)}. Default: 0}

\item{output_padding}{NA additional size added to one side of each dimension in the      output shape. Can be a single number or a tuple \code{(out_padW)}. Default: 0}

\item{groups}{NA split input into groups, \eqn{\mbox{in\_channels}} should be divisible by the      number of groups. Default: 1}

\item{dilation}{NA the spacing between kernel elements. Can be a single number or      a tuple \verb{(dW,)}. Default: 1}
}
\description{
Conv_transpose1d
}
\section{conv_transpose1d(input, weight, bias=None, stride=1, padding=0, output_padding=0, groups=1, dilation=1) -> Tensor }{


Applies a 1D transposed convolution operator over an input signal
composed of several input planes, sometimes also called "deconvolution".

See \code{~torch.nn.ConvTranspose1d} for details and output shape.

.. include:: cudnn_deterministic.rst
}

\examples{
if (torch_is_installed()) {

inputs = torch_randn(c(20, 16, 50))
weights = torch_randn(c(16, 33, 5))
nnf_conv_transpose1d(inputs, weights)
}
}
