% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setters_and_getters.R
\name{get_snps_within_region}
\alias{get_snps_within_region}
\title{Get SNPs/variants within region}
\usage{
get_snps_within_region(df, region, chr = NULL, xmin = NULL, xmax = NULL)
}
\arguments{
\item{df}{data frame of association results with the columns CHR and POS}

\item{region}{A string representing the genetic region (e.g chr16:50693587-50734041)}

\item{chr}{A string, chromosome (e.g. chr16)}

\item{xmin}{An integer, include variants with POS larger than xmin}

\item{xmax}{An integer, include variants with POS smaller than xmax}
}
\value{
the variants within the requested region
}
\description{
\code{get_snps_within_region()}
}
\examples{
get_snps_within_region(CD_UKBB, "chr16:50593587-50834041")

}
