% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_sampling.R
\name{plot.profile_likelihood}
\alias{plot.profile_likelihood}
\title{Plot Method for profile_likelihood Objects}
\usage{
\method{plot}{profile_likelihood}(x, LL_max, width = 3.5, height = 3.5, save_plot = FALSE, output_dir, ...)
}
\arguments{
\item{x}{A \code{profile_likelihood} object returned by \code{profile_likelihood()}.}

\item{LL_max}{The global maximum log-likelihood value from the entire sample set,
used as the reference for calculating the confidence interval.}

\item{width, height}{Numeric. The width and height of the output plot in inches.}

\item{save_plot}{Logical. If TRUE, the plot is saved to a file.}

\item{output_dir}{Character. The directory where the plot will be saved. Required if \code{save_plot} is TRUE.}

\item{...}{Additional arguments passed to the plot function.}
}
\value{
A ggplot object representing the profile likelihood plot.
}
\description{
Creates a visualization of the profile likelihood for a parameter, showing the
maximum likelihood estimates and the 95\% confidence interval. It supports
mathematical notation for parameter names for clearer plot labels.
}
\details{
The 95\% confidence interval is determined using the likelihood ratio test, where the
cutoff is based on the chi-squared distribution:
\eqn{LR(\theta_{ij}) = -2[log L_{max}(\theta_{ij}) - log L_{max}(\hat{\theta})]}.
The interval includes all parameter values \eqn{\theta_{ij}} for which
\eqn{LR(\theta_{ij}) \leq \chi^2_{1,0.05} \approx 3.84}.
}
\examples{
\donttest{
# This example can take more than 5 seconds to run.
# Create a sample data frame of MCMC samples
samples <- data.frame(
  log_N = log(runif(50, 2, 10)),
  log_k0 = log(runif(50, 1, 5)),
  log_cooling_rate = log(runif(50, 0.01, 0.1)),
  log_c_repulsion = log(runif(50, 0.1, 1)),
  NLL = runif(50, 20, 100)
)

# Calculate profile likelihood for the "log_N" parameter
pl_result <- profile_likelihood("log_N", samples, grid_size = 10)

# Provide the global maximum log-likelihood from the samples
LL_max <- max(-samples$NLL)

# The plot function requires the ggplot2 package
if (requireNamespace("ggplot2", quietly = TRUE)) {
  plot(pl_result, LL_max, width = 4, height = 3)
}
}
}
