% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foreign_pkgs.R, R/tobit1.R
\name{prediction_margins}
\alias{prediction_margins}
\alias{prediction.tobit1}
\alias{predict.tobit1}
\title{prediction methods}
\usage{
\method{prediction}{tobit1}(
  model,
  data = find_data(model, parent.frame()),
  at = NULL,
  type = "response",
  vcov = stats::vcov(model),
  calculate_se = FALSE,
  ...
)

\method{predict}{tobit1}(object, newdata = NULL, what = c("expvalue", "prob", "linpred"), ...)
}
\arguments{
\item{model, object}{a model fitted using \code{tobit1}}

\item{data, at, type, vcov, calculate_se}{see \code{prediction::prediction}}

\item{...}{further arguments, especially, a \code{what} argument can be
provided and will be passed to \code{predict}}

\item{newdata}{a new data frame for which the predict method should
compute the predictions}

\item{what}{for the predict method, the kind of predictions, can be
the probabilities (\code{prob}), the linear predictor (\code{linpred})
and the expected value of the response (\code{expvalue})}
}
\value{
\code{prediction} returns a data frame which is a data frame
containging the values of the covariates used for the
predictions augmented by the predicted values. \code{margins} return
an object of class \code{c('margins', 'data.frame')} which is data
frame containg the the marginal effects.
}
\description{
Methods to compute the predictions and the marginal effects for
tobit1 objects
}
\details{
\code{tobit1} exports the \code{prediction::prediction} and
\code{margins::margins} functions. \code{prediction} use the \code{predict}
method to compute the predictions in a "tidy way", it returns
the data frame provided for the predictions augmented by the
predictions. \code{margins} compute the average marginal effect of
every covariate. It uses the numerical derivatives of the
predictions using the \code{prediction} function.
}
\examples{
data("feesadm", package = "tobit1")
z <- tobit1(fees ~ expense + I(expense ^ 2) + region, feesadm)
head(predict(z))
# same with what = "expvalue", the default
head(predict(z, what = "expvalue"))
# compute the linear predictor and the probability
head(predict(z, what = "linpred"))
head(predict(z, what = "prob"))
# the prediction method returns a data frame
prediction(z, what = "prob")
# use a smaller data set
fees2 <- feesadm[5:25, ]
predict(z, newdata = fees2, what = "prob")
prediction(z, data = fees2, what = "prob")
margins(z, data = fees2, what = "prob")
summary(margins(z, data = fees2, what = "prob"))
}
