% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingKmeans.R
\name{createClusterPairsPlot}
\alias{createClusterPairsPlot}
\title{Create cluster variable plot.}
\usage{
createClusterPairsPlot(km, include = NULL, except = NULL, baseSize = 12,
  baseFamily = "serif", title = "Cluster Variable Pairs", ticks = FALSE,
  defaultTheme = theme_tufte(base_size = baseSize, base_family = baseFamily,
  ticks = ticks), themeExtra = theme(), ...)
}
\arguments{
\item{km}{an object of class \code{"toakmeans"} returned by \code{\link{computeKmeans}}.}

\item{include}{a vector of column names to include. Plot never contains variables other than in the list.
Plot would never include \code{idAlias} even if it is included explicitly.}

\item{except}{a vector of column names to exclude. Plot never contains variables from the list.}

\item{baseSize}{\code{\link{theme}} base font size.}

\item{baseFamily}{\code{\link{theme}} base font family.}

\item{title}{plot title.}

\item{ticks}{\code{logical} Show axis ticks using default theme settings (see \code{defaultTheme})?}

\item{defaultTheme}{plot theme settings with default value \code{\link[ggthemes]{theme_tufte}}. More themes
are available here: \code{\link[ggplot2]{ggtheme}} (by \href{http://ggplot2.org/}{ggplot2}) 
and \code{\link[ggthemes]{ggthemes}}.}

\item{themeExtra}{any additional \code{\link[ggplot2]{theme}} settings that override default theme.}

\item{...}{other parameters being suplied to geom's \code{aes}.}
}
\value{
ggplot object
}
\description{
Create cluster variable plot.
}
\examples{
if(interactive()){
# initialize connection to Lahman baseball database in Aster 
conn = odbcDriverConnect(connection="driver={Aster ODBC Driver};
                         server=<dbhost>;port=2406;database=<dbname>;uid=<user>;pwd=<pw>")
                         
km = computeKmeans(conn, "batting", centers=5, iterMax = 25,
                   aggregates = c("COUNT(*) cnt", "AVG(g) avg_g", "AVG(r) avg_r", "AVG(h) avg_h"),
                   id="playerid || '-' || stint || '-' || teamid || '-' || yearid", 
                   include=c('g','r','h'), scaledTableName='kmeans_test_scaled', 
                   centroidTableName='kmeans_test_centroids',
                   where="yearid > 2000")
km = computeClusterSample(conn, km, 0.01)
createClusterPairsPlot(km, title="Batters Clustered by G, H, R", ticks=FALSE)
}
}

