% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplify_shape.R
\name{simplify_shape}
\alias{simplify_shape}
\title{Simplify shape}
\usage{
simplify_shape(shp, fact = 0.1, keep.units = FALSE, keep.subunits = FALSE,
  ...)
}
\arguments{
\item{shp}{a \code{\link[sp:SpatialPolygons]{SpatialPolygons(DataFrame)}} or a \code{\link[sp:SpatialLines]{SpatialLines(DataFrame)}}, or an \code{sf} object that can be coerced to one of them.}

\item{fact}{simplification factor, number between 0 and 1 (default is 0.1)}

\item{keep.units}{d}

\item{keep.subunits}{d}

\item{...}{other arguments passed on to the underlying function \code{\link[rmapshaper:ms_simplify]{ms_simplify}} (except for the arguments \code{input}, \code{keep}, \code{keep_shapes} and \code{explode})}
}
\value{
shape in the smae class as \code{shp}
}
\description{
Simplify a shape consisting of polygons or lines. This can be useful for shapes that are too detailed for visualization, especially along natural borders such as coastlines and rivers. The number of coordinates is reduced.
}
\details{
This function is a wrapper of \code{\link[rmapshaper:ms_simplify]{ms_simplify}}. In addition, the data is preserved. Also \code{sf} objects are supported.
}
\examples{
\dontrun{
if (require(tmap)) {
    data(Europe)

    # show different simplification factors
    tm1 <- qtm(Europe \%>\% simplify_shape(fact = 0.05), title="Simplify 0.05")
    tm2 <- qtm(Europe \%>\% simplify_shape(fact = 0.1), title="Simplify 0.1")
    tm3 <- qtm(Europe \%>\% simplify_shape(fact = 0.2), title="Simplify 0.2")
    tm4 <- qtm(Europe \%>\% simplify_shape(fact = 0.5), title="Simplify 0.5")
    tmap_arrange(tm1, tm2, tm3, tm4)

    # show different options for keeping smaller (sub)units
    tm5 <- qtm(Europe \%>\% simplify_shape(keep.units = TRUE, keep.subunits = TRUE),
        title="Keep units and subunits")
    tm6 <- qtm(Europe \%>\% simplify_shape(keep.units = TRUE, keep.subunits = FALSE),
        title="Keep units, ignore small subunits")
    tm7 <- qtm(Europe \%>\% simplify_shape(keep.units = FALSE),
        title="Ignore small units and subunits")
    tmap_arrange(tm5, tm6, tm7)
}
}
}

