% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_layout.R, R/tmap_options.R
\name{tm_check_fix}
\alias{tm_check_fix}
\alias{tmap_options}
\alias{tmap_options_mode}
\alias{tmap_options_diff}
\alias{tmap_options_reset}
\alias{tmap_options_save}
\title{tmap options}
\usage{
tm_check_fix()

tmap_options(
  ...,
  crs,
  facet.max,
  facet.flip,
  free.scales,
  raster.max_cells,
  raster.warp,
  show.messages,
  show.warnings,
  output.format,
  output.size,
  output.dpi,
  animation.dpi,
  value.const,
  value.na,
  value.null,
  value.blank,
  values.var,
  values.range,
  value.neutral,
  values.scale,
  scales.var,
  scale.misc.args,
  continuous.nclass_per_legend_break,
  continuous.nclasses,
  label.format,
  label.na,
  scale,
  asp,
  bg.color,
  outer.bg.color,
  frame,
  frame.lwd,
  frame.r,
  frame.double_line,
  outer.margins,
  inner.margins,
  inner.margins.extra,
  meta.margins,
  meta.auto_margins,
  between_margin,
  panel.margin,
  component.offset,
  component.stack_margin,
  grid.mark.height,
  xylab.height,
  coords.height,
  xlab.show,
  xlab.text,
  xlab.size,
  xlab.color,
  xlab.rotation,
  xlab.space,
  xlab.fontface,
  xlab.fontfamily,
  xlab.alpha,
  xlab.side,
  ylab.show,
  ylab.text,
  ylab.size,
  ylab.color,
  ylab.rotation,
  ylab.space,
  ylab.fontface,
  ylab.fontfamily,
  ylab.alpha,
  ylab.side,
  panel.type,
  panel.wrap.pos,
  panel.xtab.pos,
  unit,
  color.sepia_intensity,
  color.saturation,
  color_vision_deficiency_sim,
  text.fontface,
  text.fontfamily,
  text.alpha,
  component.position,
  component.autoscale,
  legend.show,
  legend.design,
  legend.orientation,
  legend.position,
  legend.width,
  legend.height,
  legend.stack,
  legend.group.frame,
  legend.resize_as_group,
  legend.reverse,
  legend.na.show,
  legend.title.color,
  legend.title.size,
  legend.title.fontface,
  legend.title.fontfamily,
  legend.title.alpha,
  legend.xlab.color,
  legend.xlab.size,
  legend.xlab.fontface,
  legend.xlab.fontfamily,
  legend.xlab.alpha,
  legend.ylab.color,
  legend.ylab.size,
  legend.ylab.fontface,
  legend.ylab.fontfamily,
  legend.ylab.alpha,
  legend.text.color,
  legend.text.size,
  legend.text.fontface,
  legend.text.fontfamily,
  legend.text.alpha,
  legend.frame,
  legend.frame.lwd,
  legend.frame.r,
  legend.bg.color,
  legend.bg.alpha,
  legend.only,
  legend.absolute_fontsize,
  legend.settings.standard.portrait,
  legend.settings.standard.landscape,
  chart.show,
  chart.plot.axis.x,
  chart.plot.axis.y,
  chart.position,
  chart.width,
  chart.height,
  chart.stack,
  chart.group.frame,
  chart.resize_as_group,
  chart.reverse,
  chart.na.show,
  chart.title.color,
  chart.title.size,
  chart.title.fontface,
  chart.title.fontfamily,
  chart.title.alpha,
  chart.xlab.color,
  chart.xlab.size,
  chart.xlab.fontface,
  chart.xlab.fontfamily,
  chart.xlab.alpha,
  chart.ylab.color,
  chart.ylab.size,
  chart.ylab.fontface,
  chart.ylab.fontfamily,
  chart.ylab.alpha,
  chart.text.color,
  chart.text.size,
  chart.text.fontface,
  chart.text.fontfamily,
  chart.text.alpha,
  chart.frame,
  chart.frame.lwd,
  chart.frame.r,
  chart.bg.color,
  chart.bg.alpha,
  chart.object.color,
  title.size,
  title.color,
  title.fontface,
  title.fontfamily,
  title.alpha,
  title.bg.color,
  title.bg.alpha,
  title.padding,
  title.frame,
  title.frame.lwd,
  title.frame.r,
  title.stack,
  title.position,
  title.width,
  title.group.frame,
  title.resize_as_group,
  credits.size,
  credits.color,
  credits.fontface,
  credits.fontfamily,
  credits.alpha,
  credits.bg.color,
  credits.bg.alpha,
  credits.padding,
  credits.frame,
  credits.frame.lwd,
  credits.frame.r,
  credits.stack,
  credits.position,
  credits.width,
  credits.height,
  credits.group.frame,
  credits.resize_as_group,
  compass.north,
  compass.type,
  compass.text.size,
  compass.size,
  compass.show.labels,
  compass.cardinal.directions,
  compass.text.color,
  compass.color.dark,
  compass.color.light,
  compass.lwd,
  compass.bg.color,
  compass.bg.alpha,
  compass.margins,
  compass.stack,
  compass.position,
  compass.frame,
  compass.frame.lwd,
  compass.frame.r,
  compass.group.frame,
  compass.resize_as_group,
  logo.height,
  logo.margins,
  logo.between_margin,
  logo.stack,
  logo.position,
  logo.frame,
  logo.frame.lwd,
  logo.frame.r,
  logo.group.frame,
  logo.resize_as_group,
  scalebar.breaks,
  scalebar.width,
  scalebar.text.size,
  scalebar.text.color,
  scalebar.color.dark,
  scalebar.color.light,
  scalebar.lwd,
  scalebar.bg.color,
  scalebar.bg.alpha,
  scalebar.size,
  scalebar.margins,
  scalebar.stack,
  scalebar.position,
  scalebar.frame,
  scalebar.frame.lwd,
  scalebar.frame.r,
  scalebar.group.frame,
  scalebar.resize_as_group,
  grid.show,
  grid.labels.pos,
  grid.x,
  grid.y,
  grid.n.x,
  grid.n.y,
  grid.crs,
  grid.col,
  grid.lwd,
  grid.alpha,
  grid.labels.show,
  grid.labels.size,
  grid.labels.col,
  grid.labels.rot,
  grid.labels.format,
  grid.labels.cardinal,
  grid.labels.margin.x,
  grid.labels.margin.y,
  grid.labels.space.x,
  grid.labels.space.y,
  grid.labels.inside_frame,
  grid.ticks,
  grid.lines,
  grid.ndiscr,
  mouse_coordinates.stack,
  mouse_coordinates.position,
  mouse_coordinates.show,
  minimap.server,
  minimap.toggle,
  minimap.stack,
  minimap.position,
  minimap.show,
  panel.show,
  panel.labels,
  panel.label.size,
  panel.label.color,
  panel.label.fontface,
  panel.label.fontfamily,
  panel.label.alpha,
  panel.label.bg.color,
  panel.label.frame,
  panel.label.frame.lwd,
  panel.label.frame.r,
  panel.label.height,
  panel.label.rot,
  bbox,
  qtm.scalebar,
  qtm.minimap,
  qtm.mouse_coordinates,
  earth_boundary,
  earth_boundary.color,
  earth_boundary.lwd,
  earth_datum,
  space.color,
  check_and_fix,
  basemap.show,
  basemap.server,
  basemap.alpha,
  basemap.zoom,
  tiles.show,
  tiles.server,
  tiles.alpha,
  tiles.zoom,
  attr.color,
  crs_extra,
  crs_global,
  use_gradient,
  use_browser,
  use_WebGL,
  control.position,
  control.bases,
  control.overlays,
  control.collapse,
  set_bounds,
  set_view,
  set_zoom_limits,
  use_circle_markers,
  leaflet.options,
  title = NULL,
  main.title = NULL,
  main.title.size = NULL,
  main.title.color = NULL,
  main.title.fontface = NULL,
  main.title.fontfamily = NULL,
  main.title.position = NULL,
  fontface = NULL,
  fontfamily = NULL
)

tmap_options_mode(
  mode = NA,
  style = NULL,
  mode.specific = TRUE,
  default.options = FALSE
)

tmap_options_diff()

tmap_options_reset()

tmap_options_save(style)
}
\arguments{
\item{...}{List of tmap options to be set, or option names (characters) to be returned (see details)}

\item{crs}{Map crs (see \code{\link[=tm_shape]{tm_shape()}}). \code{NA} means the crs is specified in \code{\link[=tm_shape]{tm_shape()}}. The crs that is used by the transformation functions is defined in \code{\link[=tm_shape]{tm_shape()}}.}

\item{facet.max}{Maximum number of facets}

\item{facet.flip}{Should facets be flipped (in case of facet wrap)? This can also be set via \code{\link[=tm_facets_flip]{tm_facets_flip()}}}

\item{free.scales}{For backward compatibility: if this value is set, it will be used to impute the free arguments in the layer functions}

\item{raster.max_cells}{Maximum number of raster grid cells. Can be mode specific \code{c(plot = 3000, view = 1000, 1000)} (the last value is the fall back default)}

\item{raster.warp}{Should rasters be warped or transformed in case a different projection (crs) is used? Warping creates a new regular raster in the target crs, whereas transforming creates a (usually non-regular) raster in the target crs. The former is lossy, but much faster and is therefore the default.
When a different projection (crs) is used, a (usually) regular raster will be}

\item{show.messages}{Show messages?}

\item{show.warnings}{Show warnings?}

\item{output.format}{Output format}

\item{output.size}{Output size}

\item{output.dpi}{Output dpi}

\item{animation.dpi}{Output dpi for animations}

\item{value.const}{Default visual value constants e.g. the default fill color for \code{tm_shape(World) + tm_polygons()}. A list is required with per visual variable a value.}

\item{value.na}{Default visual values that are used to visualize NA data values. A list is required with per visual variable a value.}

\item{value.null}{Default visual values that are used to visualize null (out-of-scope) data values. A list is required with per visual variable a value.}

\item{value.blank}{Default visual values that correspond to blank. For color these are \code{"#00000000"} meaning transparent. A list is required with per visual variable a value.}

\item{values.var}{Default values when a data variable to mapped to a visual variable, e.g. a color palette. A list is required with per visual variable a value.}

\item{values.range}{Default range for values. See \code{values.range} of \code{\link[=tm_scale_categorical]{tm_scale_categorical()}}. A list is required with per visual variable a value.}

\item{value.neutral}{Default values for when a data variable to mapped to a visual variable, e.g. a color palette. A list is required with per visual variable a value.}

\item{values.scale}{Default scales (as in object sizes) for values. See \code{values.range} of \code{\link[=tm_scale_categorical]{tm_scale_categorical()}}. A list is required with per visual variable a value.}

\item{scales.var}{Default scale functions per visual variable and type of data variable. A list is required with per visual variable per data type.}

\item{scale.misc.args}{Default values of scale function-specific arguments. A list is required with per scale function and optional per visual variable.}

\item{continuous.nclass_per_legend_break}{The number of continuous legend breaks within one 'unit' (label).  The default value is 50.}

\item{continuous.nclasses}{the number of classes of a continuous scale. Should be odd.  The default value is 101.}

\item{label.format}{Format for the labels (was \code{legend.format} in tmap v3).}

\item{label.na}{Default label for missing values.}

\item{scale}{Overall scale of the map}

\item{asp}{Aspect ratio of each map. When \code{asp} is set to \code{NA} (default) the aspect ratio will be adjusted to the used shapes. When set to 0 the aspect ratio is
adjusted to the size of the device divided by the number of columns and rows.}

\item{bg.color}{Background color of the map.}

\item{outer.bg.color}{Background color of map outside the frame.}

\item{frame}{Overall frame of the map}

\item{frame.lwd}{The line width of the frame. See \code{graphics::par}, option 'lwd'.}

\item{frame.r}{The r (radius) of the frame.}

\item{frame.double_line}{The double line of the frame. \code{TRUE} or \code{FALSE}.}

\item{outer.margins}{The margins of the outer space (outside the frame. A vector of 4 values: bottom, left, top, right. The unit is the device height (for bottom and top) or width (for left and right).}

\item{inner.margins}{The margins of the inner space (inside the frame). A vector of 4 values: bottom, left, top, right. The unit is the device height (for bottom and top) or width (for left and right).}

\item{inner.margins.extra}{The extra arguments of the margins of the inner space (inside the frame). A list of arguments.}

\item{meta.margins}{The margins of the meta. A vector of 4 values: bottom, left, top, right. The unit is the device height (for bottom and top) or width (for left and right).}

\item{meta.auto_margins}{The auto_margins of the meta.}

\item{between_margin}{Margin between the map.}

\item{panel.margin}{The margin of the panel.}

\item{component.offset}{The offset of the component.}

\item{component.stack_margin}{The stack_margin of the component.}

\item{grid.mark.height}{The height of the mark of the grid.}

\item{xylab.height}{The height of the xylab.}

\item{coords.height}{The height of the coords.}

\item{xlab.show}{The visibility of the xlab. \code{TRUE} or \code{FALSE}.}

\item{xlab.text}{The text of the xlab.}

\item{xlab.size}{The size of the xlab.}

\item{xlab.color}{The color of the xlab.}

\item{xlab.rotation}{The rotation of the xlab.}

\item{xlab.space}{The space of the xlab. In terms of number of text line heights.}

\item{xlab.fontface}{The font face of the xlab. See \code{graphics::par}, option 'font'.}

\item{xlab.fontfamily}{The font family of the xlab. See \code{graphics::par}, option 'family'.}

\item{xlab.alpha}{The alpha transparency of the xlab.}

\item{xlab.side}{The side of the xlab.}

\item{ylab.show}{The visibility of the ylab. \code{TRUE} or \code{FALSE}.}

\item{ylab.text}{The text of the ylab.}

\item{ylab.size}{The size of the ylab.}

\item{ylab.color}{The color of the ylab.}

\item{ylab.rotation}{The rotation of the ylab.}

\item{ylab.space}{The space of the ylab. In terms of number of text line heights.}

\item{ylab.fontface}{The font face of the ylab. See \code{graphics::par}, option 'font'.}

\item{ylab.fontfamily}{The font family of the ylab. See \code{graphics::par}, option 'family'.}

\item{ylab.alpha}{The alpha transparency of the ylab.}

\item{ylab.side}{The side of the ylab.}

\item{panel.type}{The type of the panel.}

\item{panel.wrap.pos}{The panel positions for wrapped facets created with \code{\link[=tm_facets_grid]{tm_facets_grid()}}. One of \code{"left"}, \code{"right"}, \code{"top"} (default) or \code{"bottom"}.}

\item{panel.xtab.pos}{The panel positions for grid facets created with \code{\link[=tm_facets_grid]{tm_facets_grid()}}. Vector of two, where the first determines the locations of row panels (\code{"left"} or \code{"right"}) and the second the location of column panels ( \code{"top"} or `"bottom")}

\item{unit}{Unit of the coordinate}

\item{color.sepia_intensity}{The sepia_intensity of the color.}

\item{color.saturation}{The saturation of the color.}

\item{color_vision_deficiency_sim}{`Color vision deficiency simulation}

\item{text.fontface}{The font face of the text. See \code{graphics::par}, option 'font'.}

\item{text.fontfamily}{The font family of the text. See \code{graphics::par}, option 'family'.}

\item{text.alpha}{The alpha transparency of the text.}

\item{component.position}{The position of the component. A tm_pos object, or a shortcut of two values: horizontal (left, center, right) and vertical (top, center, bottom). See tm_pos for details}

\item{component.autoscale}{The autoscale of the component.}

\item{legend.show}{The visibility of the legend. \code{TRUE} or \code{FALSE}.}

\item{legend.design}{The design of the legend.}

\item{legend.orientation}{The orientation of the legend.}

\item{legend.position}{The position of the legend. A tm_pos object, or a shortcut of two values: horizontal (left, center, right) and vertical (top, center, bottom). See tm_pos for details}

\item{legend.width}{The width of the legend.}

\item{legend.height}{The height of the legend.}

\item{legend.stack}{The stack of the legend.}

\item{legend.group.frame}{The frame of the group of the legend.}

\item{legend.resize_as_group}{The resize_as_group of the legend.}

\item{legend.reverse}{The reverse of the legend.}

\item{legend.na.show}{The visibility of the na of the legend. \code{TRUE} or \code{FALSE}.}

\item{legend.title.color}{The color of the title of the legend.}

\item{legend.title.size}{The size of the title of the legend.}

\item{legend.title.fontface}{The font face of the title of the legend. See \code{graphics::par}, option 'font'.}

\item{legend.title.fontfamily}{The font family of the title of the legend. See \code{graphics::par}, option 'family'.}

\item{legend.title.alpha}{The alpha transparency of the title of the legend.}

\item{legend.xlab.color}{The color of the xlab of the legend.}

\item{legend.xlab.size}{The size of the xlab of the legend.}

\item{legend.xlab.fontface}{The font face of the xlab of the legend. See \code{graphics::par}, option 'font'.}

\item{legend.xlab.fontfamily}{The font family of the xlab of the legend. See \code{graphics::par}, option 'family'.}

\item{legend.xlab.alpha}{The alpha transparency of the xlab of the legend.}

\item{legend.ylab.color}{The color of the ylab of the legend.}

\item{legend.ylab.size}{The size of the ylab of the legend.}

\item{legend.ylab.fontface}{The font face of the ylab of the legend. See \code{graphics::par}, option 'font'.}

\item{legend.ylab.fontfamily}{The font family of the ylab of the legend. See \code{graphics::par}, option 'family'.}

\item{legend.ylab.alpha}{The alpha transparency of the ylab of the legend.}

\item{legend.text.color}{The color of the text of the legend.}

\item{legend.text.size}{The size of the text of the legend.}

\item{legend.text.fontface}{The font face of the text of the legend. See \code{graphics::par}, option 'font'.}

\item{legend.text.fontfamily}{The font family of the text of the legend. See \code{graphics::par}, option 'family'.}

\item{legend.text.alpha}{The alpha transparency of the text of the legend.}

\item{legend.frame}{The frame of the legend.}

\item{legend.frame.lwd}{The line width of the frame of the legend. See \code{graphics::par}, option 'lwd'.}

\item{legend.frame.r}{The r (radius) of the frame of the legend.}

\item{legend.bg.color}{The color of the bg of the legend.}

\item{legend.bg.alpha}{The alpha transparency of the bg of the legend.}

\item{legend.only}{The only of the legend.}

\item{legend.absolute_fontsize}{The absolute fontsize of the legend. So far, only used to calculate legend dimensions}

\item{legend.settings.standard.portrait}{The portrait of the standard of the settings of the legend.}

\item{legend.settings.standard.landscape}{The landscape of the standard of the settings of the legend.}

\item{chart.show}{The visibility of the chart. \code{TRUE} or \code{FALSE}.}

\item{chart.plot.axis.x}{The x of the axis of the plot of the chart.}

\item{chart.plot.axis.y}{The y of the axis of the plot of the chart.}

\item{chart.position}{The position of the chart. A tm_pos object, or a shortcut of two values: horizontal (left, center, right) and vertical (top, center, bottom). See tm_pos for details}

\item{chart.width}{The width of the chart.}

\item{chart.height}{The height of the chart.}

\item{chart.stack}{The stack of the chart.}

\item{chart.group.frame}{The frame of the group of the chart.}

\item{chart.resize_as_group}{The resize_as_group of the chart.}

\item{chart.reverse}{The reverse of the chart.}

\item{chart.na.show}{The visibility of the na of the chart. \code{TRUE} or \code{FALSE}.}

\item{chart.title.color}{The color of the title of the chart.}

\item{chart.title.size}{The size of the title of the chart.}

\item{chart.title.fontface}{The font face of the title of the chart. See \code{graphics::par}, option 'font'.}

\item{chart.title.fontfamily}{The font family of the title of the chart. See \code{graphics::par}, option 'family'.}

\item{chart.title.alpha}{The alpha transparency of the title of the chart.}

\item{chart.xlab.color}{The color of the xlab of the chart.}

\item{chart.xlab.size}{The size of the xlab of the chart.}

\item{chart.xlab.fontface}{The font face of the xlab of the chart. See \code{graphics::par}, option 'font'.}

\item{chart.xlab.fontfamily}{The font family of the xlab of the chart. See \code{graphics::par}, option 'family'.}

\item{chart.xlab.alpha}{The alpha transparency of the xlab of the chart.}

\item{chart.ylab.color}{The color of the ylab of the chart.}

\item{chart.ylab.size}{The size of the ylab of the chart.}

\item{chart.ylab.fontface}{The font face of the ylab of the chart. See \code{graphics::par}, option 'font'.}

\item{chart.ylab.fontfamily}{The font family of the ylab of the chart. See \code{graphics::par}, option 'family'.}

\item{chart.ylab.alpha}{The alpha transparency of the ylab of the chart.}

\item{chart.text.color}{The color of the text of the chart.}

\item{chart.text.size}{The size of the text of the chart.}

\item{chart.text.fontface}{The font face of the text of the chart. See \code{graphics::par}, option 'font'.}

\item{chart.text.fontfamily}{The font family of the text of the chart. See \code{graphics::par}, option 'family'.}

\item{chart.text.alpha}{The alpha transparency of the text of the chart.}

\item{chart.frame}{The frame of the chart.}

\item{chart.frame.lwd}{The line width of the frame of the chart. See \code{graphics::par}, option 'lwd'.}

\item{chart.frame.r}{The r (radius) of the frame of the chart.}

\item{chart.bg.color}{The color of the bg of the chart.}

\item{chart.bg.alpha}{The alpha transparency of the bg of the chart.}

\item{chart.object.color}{The color of the object of the chart.}

\item{title.size}{The size of the title.}

\item{title.color}{The color of the title.}

\item{title.fontface}{The font face of the title. See \code{graphics::par}, option 'font'.}

\item{title.fontfamily}{The font family of the title. See \code{graphics::par}, option 'family'.}

\item{title.alpha}{The alpha transparency of the title.}

\item{title.bg.color}{The color of the bg of the title.}

\item{title.bg.alpha}{The alpha transparency of the bg of the title.}

\item{title.padding}{The padding of the title. A vector of 4 values: bottom, left, top, right. The unit is the device height (for bottom and top) or width (for left and right).}

\item{title.frame}{The frame of the title.}

\item{title.frame.lwd}{The line width of the frame of the title. See \code{graphics::par}, option 'lwd'.}

\item{title.frame.r}{The r (radius) of the frame of the title.}

\item{title.stack}{The stack of the title.}

\item{title.position}{The position of the title. A tm_pos object, or a shortcut of two values: horizontal (left, center, right) and vertical (top, center, bottom). See tm_pos for details}

\item{title.width}{The width of the title.}

\item{title.group.frame}{The frame of the group of the title.}

\item{title.resize_as_group}{The resize_as_group of the title.}

\item{credits.size}{The size of the credits.}

\item{credits.color}{The color of the credits.}

\item{credits.fontface}{The font face of the credits. See \code{graphics::par}, option 'font'.}

\item{credits.fontfamily}{The font family of the credits. See \code{graphics::par}, option 'family'.}

\item{credits.alpha}{The alpha transparency of the credits.}

\item{credits.bg.color}{The color of the bg of the credits.}

\item{credits.bg.alpha}{The alpha transparency of the bg of the credits.}

\item{credits.padding}{The padding of the credits. A vector of 4 values: bottom, left, top, right. The unit is the device height (for bottom and top) or width (for left and right).}

\item{credits.frame}{The frame of the credits.}

\item{credits.frame.lwd}{The line width of the frame of the credits. See \code{graphics::par}, option 'lwd'.}

\item{credits.frame.r}{The r (radius) of the frame of the credits.}

\item{credits.stack}{The stack of the credits.}

\item{credits.position}{The position of the credits. A tm_pos object, or a shortcut of two values: horizontal (left, center, right) and vertical (top, center, bottom). See tm_pos for details}

\item{credits.width}{The width of the credits.}

\item{credits.height}{The height of the credits.}

\item{credits.group.frame}{The frame of the group of the credits.}

\item{credits.resize_as_group}{The resize_as_group of the credits.}

\item{compass.north}{The north of the compass.}

\item{compass.type}{The type of the compass.}

\item{compass.text.size}{The size of the text of the compass.}

\item{compass.size}{The size of the compass.}

\item{compass.show.labels}{The labels of the show of the compass.}

\item{compass.cardinal.directions}{The directions of the cardinal of the compass.}

\item{compass.text.color}{The color of the text of the compass.}

\item{compass.color.dark}{The dark of the color of the compass.}

\item{compass.color.light}{The light of the color of the compass.}

\item{compass.lwd}{The line width of the compass. See \code{graphics::par}, option 'lwd'.}

\item{compass.bg.color}{The color of the bg of the compass.}

\item{compass.bg.alpha}{The alpha transparency of the bg of the compass.}

\item{compass.margins}{The margins of the compass. A vector of 4 values: bottom, left, top, right. The unit is the device height (for bottom and top) or width (for left and right).}

\item{compass.stack}{The stack of the compass.}

\item{compass.position}{The position of the compass. A tm_pos object, or a shortcut of two values: horizontal (left, center, right) and vertical (top, center, bottom). See tm_pos for details}

\item{compass.frame}{The frame of the compass.}

\item{compass.frame.lwd}{The line width of the frame of the compass. See \code{graphics::par}, option 'lwd'.}

\item{compass.frame.r}{The r (radius) of the frame of the compass.}

\item{compass.group.frame}{The frame of the group of the compass.}

\item{compass.resize_as_group}{The resize_as_group of the compass.}

\item{logo.height}{The height of the logo.}

\item{logo.margins}{The margins of the logo. A vector of 4 values: bottom, left, top, right. The unit is the device height (for bottom and top) or width (for left and right).}

\item{logo.between_margin}{The between_margin of the logo.}

\item{logo.stack}{The stack of the logo.}

\item{logo.position}{The position of the logo. A tm_pos object, or a shortcut of two values: horizontal (left, center, right) and vertical (top, center, bottom). See tm_pos for details}

\item{logo.frame}{The frame of the logo.}

\item{logo.frame.lwd}{The line width of the frame of the logo. See \code{graphics::par}, option 'lwd'.}

\item{logo.frame.r}{The r (radius) of the frame of the logo.}

\item{logo.group.frame}{The frame of the group of the logo.}

\item{logo.resize_as_group}{The resize_as_group of the logo.}

\item{scalebar.breaks}{The break values of the scalebar.}

\item{scalebar.width}{The width of the scalebar.}

\item{scalebar.text.size}{The size of the text of the scalebar.}

\item{scalebar.text.color}{The color of the text of the scalebar.}

\item{scalebar.color.dark}{The dark of the color of the scalebar.}

\item{scalebar.color.light}{The light of the color of the scalebar.}

\item{scalebar.lwd}{The line width of the scalebar. See \code{graphics::par}, option 'lwd'.}

\item{scalebar.bg.color}{The color of the bg of the scalebar.}

\item{scalebar.bg.alpha}{The alpha transparency of the bg of the scalebar.}

\item{scalebar.size}{The size of the scalebar.}

\item{scalebar.margins}{The margins of the scalebar. A vector of 4 values: bottom, left, top, right. The unit is the device height (for bottom and top) or width (for left and right).}

\item{scalebar.stack}{The stack of the scalebar.}

\item{scalebar.position}{The position of the scalebar. A tm_pos object, or a shortcut of two values: horizontal (left, center, right) and vertical (top, center, bottom). See tm_pos for details}

\item{scalebar.frame}{The frame of the scalebar.}

\item{scalebar.frame.lwd}{The line width of the frame of the scalebar. See \code{graphics::par}, option 'lwd'.}

\item{scalebar.frame.r}{The r (radius) of the frame of the scalebar.}

\item{scalebar.group.frame}{The frame of the group of the scalebar.}

\item{scalebar.resize_as_group}{The resize_as_group of the scalebar.}

\item{grid.show}{The visibility of the grid. \code{TRUE} or \code{FALSE}.}

\item{grid.labels.pos}{The pos of the labels of the grid.}

\item{grid.x}{The x of the grid.}

\item{grid.y}{The y of the grid.}

\item{grid.n.x}{The x of the n of the grid.}

\item{grid.n.y}{The y of the n of the grid.}

\item{grid.crs}{The coordinate reference system (CRS) of the grid.}

\item{grid.col}{The color of the grid.}

\item{grid.lwd}{The line width of the grid. See \code{graphics::par}, option 'lwd'.}

\item{grid.alpha}{The alpha transparency of the grid.}

\item{grid.labels.show}{The visibility of the labels of the grid. \code{TRUE} or \code{FALSE}.}

\item{grid.labels.size}{The size of the labels of the grid.}

\item{grid.labels.col}{The color of the labels of the grid.}

\item{grid.labels.rot}{The rot of the labels of the grid.}

\item{grid.labels.format}{The format of the labels of the grid.}

\item{grid.labels.cardinal}{The cardinal of the labels of the grid.}

\item{grid.labels.margin.x}{The x of the margin of the labels of the grid.}

\item{grid.labels.margin.y}{The y of the margin of the labels of the grid.}

\item{grid.labels.space.x}{The x of the space of the labels of the grid.}

\item{grid.labels.space.y}{The y of the space of the labels of the grid.}

\item{grid.labels.inside_frame}{The inside_frame of the labels of the grid.}

\item{grid.ticks}{The ticks of the grid.}

\item{grid.lines}{The lines of the grid.}

\item{grid.ndiscr}{The ndiscr of the grid.}

\item{mouse_coordinates.stack}{The stack of the mouse_coordinates.}

\item{mouse_coordinates.position}{The position of the mouse_coordinates. A tm_pos object, or a shortcut of two values: horizontal (left, center, right) and vertical (top, center, bottom). See tm_pos for details}

\item{mouse_coordinates.show}{The visibility of the mouse_coordinates. \code{TRUE} or \code{FALSE}.}

\item{minimap.server}{The server of the minimap.}

\item{minimap.toggle}{The toggle of the minimap.}

\item{minimap.stack}{The stack of the minimap.}

\item{minimap.position}{The position of the minimap. A tm_pos object, or a shortcut of two values: horizontal (left, center, right) and vertical (top, center, bottom). See tm_pos for details}

\item{minimap.show}{The visibility of the minimap. \code{TRUE} or \code{FALSE}.}

\item{panel.show}{The visibility of the panel. \code{TRUE} or \code{FALSE}.}

\item{panel.labels}{The labels of the panel.}

\item{panel.label.size}{The size of the label of the panel.}

\item{panel.label.color}{The color of the label of the panel.}

\item{panel.label.fontface}{The font face of the label of the panel. See \code{graphics::par}, option 'font'.}

\item{panel.label.fontfamily}{The font family of the label of the panel. See \code{graphics::par}, option 'family'.}

\item{panel.label.alpha}{The alpha transparency of the label of the panel.}

\item{panel.label.bg.color}{The color of the bg of the label of the panel.}

\item{panel.label.frame}{The frame of the label of the panel.}

\item{panel.label.frame.lwd}{The line width of the frame of the label of the panel. See \code{graphics::par}, option 'lwd'.}

\item{panel.label.frame.r}{The r (radius) of the frame of the label of the panel.}

\item{panel.label.height}{The height of the label of the panel.}

\item{panel.label.rot}{The rot of the label of the panel.}

\item{bbox}{Bounding box of the map (only used if \code{shp} is the main shape (see \code{is.main})}

\item{qtm.scalebar}{The scalebar of the qtm.}

\item{qtm.minimap}{The minimap of the qtm.}

\item{qtm.mouse_coordinates}{The mouse_coordinates of the qtm.}

\item{earth_boundary}{The earth boundary}

\item{earth_boundary.color}{The color of the earth_boundary.}

\item{earth_boundary.lwd}{The line width of the earth_boundary. See \code{graphics::par}, option 'lwd'.}

\item{earth_datum}{Earth datum}

\item{space.color}{The color of the space.}

\item{check_and_fix}{Should attempt to fix an invalid shapefile}

\item{basemap.show}{The visibility of the basemap. \code{TRUE} or \code{FALSE}.}

\item{basemap.server}{The server of the basemap.}

\item{basemap.alpha}{The alpha transparency of the basemap.}

\item{basemap.zoom}{The zoom of the basemap.}

\item{tiles.show}{The visibility of the tiles. \code{TRUE} or \code{FALSE}.}

\item{tiles.server}{The server of the tiles.}

\item{tiles.alpha}{The alpha transparency of the tiles.}

\item{tiles.zoom}{The zoom of the tiles.}

\item{attr.color}{The color of the attr.}

\item{crs_extra}{Only used internally (work in progress)}

\item{crs_global}{The used crs for world maps}

\item{use_gradient}{Use gradient fill using \link[grid:patterns]{linearGradient()}}

\item{use_browser}{If \code{TRUE} it opens an external browser, and \code{FALSE} (default) it opens the internal IDEs (e.g. RStudio) browser.}

\item{use_WebGL}{use webGL for points, lines, and polygons. For large spatial objects, this is much faster than the standard leaflet layer functions. However, it can not always be used for two reasons. First, the number of visual variables are limited; only fill, size, and color (for lines) are supported. Second, projected CRS's are not supported. Furthermore, it has the drawback that polygon borders are not as sharp. By default only \code{TRUE} for large spatial objects (500 or more features) when the mentioned criteria are met.
By default \code{TRUE} if no other visual variables are used.}

\item{control.position}{The position of the control. A tm_pos object, or a shortcut of two values: horizontal (left, center, right) and vertical (top, center, bottom). See tm_pos for details}

\item{control.bases}{base layers}

\item{control.overlays}{overlay layers}

\item{control.collapse}{Should the box be collapsed or expanded?}

\item{set_bounds}{logical that determines whether maximum bounds are set,
or a bounding box. Not applicable in plot mode.
In view mode, this is passed on to \link[leaflet:map-methods]{setMaxBounds()}}

\item{set_view}{numeric vector that determines the view.
Either a vector of three: \code{lng}, \code{lat}, and \code{zoom}, or a single value:
\code{zoom}. See \link[leaflet:map-methods]{setView()}.
Only applicable if \code{bbox} is not specified}

\item{set_zoom_limits}{numeric vector of two that set the minimum and maximum
zoom levels (see \link[leaflet:map-options]{tileOptions()}).}

\item{use_circle_markers}{If \code{TRUE} (default) circle shaped symbols (e.g. \code{tm_dots()} and \code{tm_symbols()}) will be rendered as \link[leaflet:map-layers]{addCircleMarkers()} instead of \link[leaflet:map-layers]{addMarkers()}. The former is faster, the latter can support any symbol since it is based on icons}

\item{leaflet.options}{options passed on to
\link[leaflet:leaflet]{leafletOptions()}}

\item{title}{deprecated See \code{\link[=tm_title]{tm_title()}}}

\item{main.title}{deprecated See \code{\link[=tm_title]{tm_title()}}}

\item{main.title.size, main.title.color, main.title.fontface, main.title.fontfamily, main.title.position}{deprecated. Use the \code{title.} options instead.}

\item{fontface, fontfamily}{renamed to \code{text.fontface} and \code{text.fontfamily}}

\item{mode}{mode, e.g. \code{"plot"} or \code{"view"}}

\item{style}{style, see \code{\link[=tmap_style]{tmap_style()}} for available styles}

\item{mode.specific}{Should only mode-specific options be returned? \code{TRUE} by default.}

\item{default.options}{return the default options or the current options?}
}
\description{
Get or set the tmap options globally. For map specific options, we recommend to use \code{\link[=tm_options]{tm_options()}} or \code{\link[=tm_layout]{tm_layout()}} via which the layout-related options can be set. \code{\link[=tmap_options]{tmap_options()}} functions similar to \code{\link[base:options]{base::options()}}.
}
\examples{
# get all options
opt = tmap_options()

# print as a tree
if (requireNamespace("lobstr")) {
	lobstr::tree(opt)
}

# a fancy set of options:
tmap_options(
  bg.color = "steelblue",
  outer.bg.color = "salmon",
  frame = "purple3",
  frame.lwd = 5,
  compass.type = "8star",
  legend.bg.color = "gold",
  legend.position = tm_pos_in(pos.h = "left", pos.v = "top")
 )

if (requireNamespace("lobstr")) {
	lobstr::tree(
		tmap_options_diff()
	)
}

tm_shape(World) +
	tm_polygons("footprint")

tmap_options_save("fancy")

# the default style:
tmap_style("white")

tm_shape(World) +
	tm_polygons("footprint")

tmap_style("fancy")

tm_shape(World) +
	tm_polygons("footprint")

# reset all options
tmap_options_reset()
}
