% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_facets.R
\name{tm_facets}
\alias{tm_facets}
\alias{tm_facets_grid}
\alias{tm_facets_wrap}
\alias{tm_facets_pagewise}
\alias{tm_facets_stack}
\alias{tm_facets_hstack}
\alias{tm_facets_vstack}
\alias{tm_facets_flip}
\title{Specify facets}
\usage{
tm_facets(
  by = NULL,
  rows = NULL,
  columns = NULL,
  pages = NULL,
  as.layers = FALSE,
  nrow = NA,
  ncol = NA,
  byrow = TRUE,
  orientation = NA,
  free.coords = NA,
  drop.units = TRUE,
  drop.empty.facets = TRUE,
  drop.NA.facets = FALSE,
  sync = TRUE,
  na.text = NA,
  scale.factor = 2,
  type = NA,
  along = NULL,
  free.scales = NULL,
  ...
)

tm_facets_grid(rows = NULL, columns = NULL, pages = NULL, ...)

tm_facets_wrap(by = "VARS__", nrow = NA, ncol = NA, byrow = TRUE, ...)

tm_facets_pagewise(by = "VARS__", nrow = 1, ncol = 1, byrow = TRUE, ...)

tm_facets_stack(by = "VARS__", orientation = NA, ...)

tm_facets_hstack(by = "VARS__", ...)

tm_facets_vstack(by = "VARS__", ...)

tm_facets_flip(...)
}
\arguments{
\item{by}{Group by variable (only for a facet wrap or facet stack)}

\item{rows}{Variable that specifies the rows (only for a facet grid)}

\item{columns}{Variable that specifies the columns (only for a facet grid)}

\item{pages}{Variable that specifies the pages (only for a facet grid)}

\item{as.layers}{show facets as layers?}

\item{nrow}{Number of rows}

\item{ncol}{Number of columns}

\item{byrow}{Should facets be wrapped by row?}

\item{orientation}{For facet stack: horizontal or vertical?}

\item{free.coords}{Logical. If the \code{by} argument is specified, should each
map has its own coordinate ranges? By default \code{TRUE}, unless facets are shown
in as different layers (\code{as.layers = TRUE})}

\item{drop.units}{Logical. If the \code{by} argument is specified, should
non-selected spatial units be dropped? If \code{FALSE}, they are plotted where
mapped aesthetics are regarded as missing values. Not applicable for
raster shapes. By default \code{TRUE}.}

\item{drop.empty.facets}{Logical. If the \code{by} argument is specified, should
empty facets be dropped? Empty facets occur when the \code{by}-variable contains
unused levels. When \code{TRUE} and two \code{by}-variables are specified, empty rows
and columns are dropped.}

\item{drop.NA.facets}{Logical. If the \code{by} argument is specified, and all
data values for specific facets are missing, should these facets be dropped?
\code{FALSE} by default. In v3, it was called \code{showNA}.}

\item{sync}{Logical. Should the navigation in view mode (zooming and panning)
be synchronized? By default \code{TRUE} if the facets have the same bounding box.
This is generally the case when rasters are plotted, or when \code{free.coords} is
\code{FALSE}.}

\item{na.text}{Text used for facets of missing values. In v3, it was \code{textNA}.}

\item{scale.factor}{Number that determines how the elements (e.g. font sizes,
symbol sizes, line widths) of the small multiples are scaled in relation to
the scaling factor of the shapes. The elements are scaled to the \code{scale.factor}th
root of the scaling factor of the shapes. So, for \code{scale.factor = 1},
they are scaled proportional to the scaling of the shapes. Since elements,
especially text, are often too small to read, a higher value is recommended.
By default, \code{scale.factor = 2}.}

\item{type}{\code{"grid"}, \code{"wrap"} or \code{"stack"}}

\item{along}{deprecated Please use \code{tm_facets_pagewise()}}

\item{free.scales}{deprecated. Please use the \code{.free} arguments in the layer functions, e.g. \code{fill.free} in \code{tm_polygons}.}

\item{...}{passed on to \code{tm_facets()}}
}
\description{
\itemize{
\item \code{tm_facets_wrap()} specify facets for one grouping variable (so one faceting dimension).
\item \verb{tm_facets_(hv)stack()} stacks the facets either horizontally or vertically (one grouping variable).
\item \code{tm_facets_grid()} supports up to three faceting dimensions.
\item \code{tm_facets_pagewise()} can be used to replace the old \code{along} argument.
\item \code{tm_facets_flip()} can be used to flip facets.
\item \code{tm_facets()} is the core function, but it is recommended to use the other functions.
}
}
\examples{
\dontrun{
tm_shape(NLD_dist) +
  tm_polygons("edu_appl_sci",
    fill.scale = tm_scale_intervals(values = "pu_gn", style = "kmeans", n = 7)) +
  tm_facets(by = "province") +
tm_shape(NLD_muni) +
  tm_borders(lwd = 3) +
  tm_facets(by = "province") +
tm_title("Population with a univeristy degree (incl appl. sciences), percentages")

tm_shape(World) +
  tm_polygons(c("gender", "press"),
    fill.scale = list(tm_scale_intervals(values = "bu_br_div", midpoint = 0.5),
      tm_scale_intervals(values = "pu_gn_div", midpoint = 50)),
    fill.legend = tm_legend("")) +
tm_layout(panel.labels = c("Gender Inequality Index (GII)", "World Press Freedom Index"))
}
}
\seealso{
\href{https://r-tmap.github.io/tmap/articles/basics_facets}{Vignette about facets}
}
