% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmap_grob.R
\name{tmap_grob}
\alias{tmap_grob}
\title{Export to grob object}
\usage{
tmap_grob(tm)
}
\arguments{
\item{tm}{tmap object}
}
\value{
A grob object when one page is generated, or a list of grob objects when multiple pages are generated.
}
\description{
Export a tmap plot object to a grob object (from the grid package).
}
\examples{
\dontrun{
	
data(World)
m <- tm_shape(World) +
	tm_fill("well_being", id="name", title="Well-being")

grb = tmap_grob(m)

library(grid)

grid.newpage()
pushViewport(viewport(x = 0.1, y = 0.1, width = 0.2, height = 0.2))
grid.draw(grb)
upViewport()
pushViewport(viewport(x = 0.6, y = 0.6, width = 0.8, height = 0.8))
grid.draw(grb)
	
}
}
