% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tip_lm.R
\name{tip_lm}
\alias{tip_lm}
\alias{lm_tip}
\title{Tip a linear model result with a continuous confounder.}
\usage{
tip_lm(
  effect,
  smd = NULL,
  outcome_association = NULL,
  verbose = TRUE,
  correction_factor = "none"
)

lm_tip(effect, smd, outcome_association, verbose = TRUE)
}
\arguments{
\item{effect}{Numeric. Observed exposure - outcome effect from a regression
model. This can be the beta coefficient, the lower confidence bound of
the beta coefficient, or the upper confidence bound of the beta
coefficient.}

\item{smd}{Numeric. Estimated scaled mean difference between the
unmeasured confounder in the exposed population and unexposed population}

\item{outcome_association}{Numeric positive value. Estimated association
between the unmeasured confounder and the outcome}

\item{verbose}{Logical. Indicates whether to print informative message.
Default: \code{TRUE}}

\item{correction_factor}{Character string. Options are "none", "hr", "or".
For common outcomes (>15\%), the odds ratio or hazard ratio is not a good
estimate for the relative risk. In these cases, we can apply a correction
factor. If you are supplying a hazard ratio for a common outcome, set
this to "hr"; if you are supplying an odds ratio for a common outcome, set
this to "or"; if you are supplying a risk ratio or your outcome is rare,
set this to "none" (default).}
}
\value{
Data frame.
}
\description{
choose one of the following, and the other will be estimated:
\itemize{
\item \code{smd}
\item \code{outcome_association}
}
}
\examples{
## to estimate the association between an unmeasured confounder and outcome
## needed to tip analysis
tip_lm(1.2, smd = -2)

## to estimate the number of unmeasured confounders specified needed to tip
## the analysis
tip_lm(1.2, smd = -2, outcome_association = -0.05)

## Example with broom
if (requireNamespace("broom", quietly = TRUE) &&
    requireNamespace("dplyr", quietly = TRUE)) {
  lm(wt ~ mpg, data = mtcars) \%>\%
   broom::tidy(conf.int = TRUE) \%>\%
   dplyr::filter(term == "mpg") \%>\%
   dplyr::pull(conf.low) \%>\%
   tip_lm(outcome_association = 2.5)
}
}
