sanitize_ribbon.alpha = function(ribbon.alpha) {
  assert_numeric(ribbon.alpha, len = 1, lower = 0, upper = 1, null.ok = TRUE)
  if (is.null(ribbon.alpha)) ribbon.alpha = .tpar[["ribbon.alpha"]]
  return(ribbon.alpha)
}



sanitize_type = function(type, x, y, dots) {
  if (inherits(type, "tinyplot_type")) {
    return(type)
  }

  known_types = c(
    "p", "l", "o", "b", "c", "h", "j", "s", "S", "n", 
    "abline",
    "area",
    "bar", "barplot",
    "box", "boxplot",
    "density",
    "errorbar",
    "function",
    "glm",
    "hist", "histogram",
    "hline",
    "j", "jitter",
    "lines",
    "lm",
    "loess",
    "pointrange",
    "points",
    "polygon", "polypath",
    "qq",
    "rect",
    "ribbon",
    "ridge",
    "rug",
    "segments",
    "spine", "spineplot",
    "spline",
    "summary",
    "text",
    "violin",
    "vline"
  )
  assert_choice(type, known_types, null.ok = TRUE)

  if (is.null(type)) {
    if (!is.null(x) && (is.factor(x) || is.character(x)) && !(is.factor(y) || is.character(y))) {
      # enforce boxplot type for y ~ factor(x)
      type = type_boxplot
    } else if (is.factor(y) || is.character(y)) {
      # enforce spineplot type for factor(y) ~ x
      type = type_spineplot
    } else {
      type = "p"
    }
  }

  if (is.character(type)) type = switch(type,
    "abline"     = type_abline,
    "area"       = type_area,
    "bar"        = type_barplot,
    "barplot"    = type_barplot,
    "box"        = type_boxplot,
    "boxplot"    = type_boxplot,
    "density"    = type_density,
    "errorbar"   = type_errorbar,
    "function"   = type_function,
    "glm"        = type_glm,
    "hist"       = type_histogram,
    "histogram"  = type_histogram,
    "hline"      = type_hline,
    "j"          = type_jitter,
    "jitter"     = type_jitter,
    "lines"      = type_lines,
    "lm"         = type_lm,
    "loess"      = type_loess,
    "p"          = type_points,
    "pointrange" = type_pointrange,
    "points"     = type_points,
    "polygon"    = type_polygon,
    "polypath"   = type_polypath,
    "qq"         = type_qq,
    "rect"       = type_rect,
    "ribbon"     = type_ribbon,
    "ridge"      = type_ridge,
    "rug"        = type_rug,
    "segments"   = type_segments,
    "spine"      = type_spineplot,
    "spineplot"  = type_spineplot,
    "spline"     = type_spline,
    "summary"    = type_summary,
    "text"       = type_text,
    "violin"     = type_violin,
    "vline"      = type_vline,
    type           # default case
  )
  
  if (is.function(type)) {
    args = intersect(names(formals(type)), names(dots))
    args = if (length(args) >= 1L) dots[args] else list()
    type = do.call(type, args)
    type$dots = dots[setdiff(names(dots), names(args))]
  }
  
  if (inherits(type, "tinyplot_type")) return(type)

  out = list(draw = NULL, data = NULL, name = type)
  return(out)
}



sanitize_axes = function(axes, xaxt, yaxt, frame.plot) {
  ## handle defaults of axes, xaxt, yaxt, frame.plot
  ## - convert axes to character if necessary
  ## - set defaults of xaxt/yaxt (if these are NULL) based on axes
  ## - set logical axes based on xaxt/yaxt
  ## - set frame.plot default based on xaxt/yaxt
  if (isFALSE(axes)) {
    axes = xaxt = yaxt = "none"
  } else if (isTRUE(axes)) {
    axes = "standard"
    if (is.null(xaxt)) xaxt = get_tpar("xaxt", default = "standard")
    if (is.null(yaxt)) yaxt = get_tpar("yaxt", default = "standard")
  } else {
    xaxt = yaxt = axes
  }
  axis_types = c("standard", "none", "labels", "ticks", "axis")
  axes = match.arg(axes, axis_types)
  xaxt = match.arg(xaxt, axis_types)
  yaxt = match.arg(yaxt, axis_types)
  xaxt = substr(match.arg(xaxt, axis_types), 1L, 1L)
  yaxt = substr(match.arg(yaxt, axis_types), 1L, 1L)
  axes = any(c(xaxt, yaxt) != "n")
  if (is.null(frame.plot) || !is.logical(frame.plot)) frame.plot = all(c(xaxt, yaxt) %in% c("s", "a"))
  return(list(axes = axes, xaxt = xaxt, yaxt = yaxt, frame.plot = frame.plot))
}
