% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_arithmetic.R
\name{str_arithmetic}
\alias{str_arithmetic}
\alias{\%s-\%}
\alias{\%s/\%}
\alias{\%s//\%}
\alias{\%ss\%}
\title{String Arithmetic Operators}
\usage{
x \%s-\% p

x \%s/\% p

x \%s//\% brk

x \%ss\% p
}
\arguments{
\item{x}{a string or character vector.}

\item{p}{either a list with 'stringi' arguments (see \link{s_pattern}),
or else a character vector of the same length as \code{x} or length 1
with regular expressions. \cr
\ifelse{html}{\href{https://stringi.gagolewski.com/rapi/about_search_regex.html}{\figure{aboutsearch-regex-darkred.svg}{options: alt='[REGEX]'}}}{\href{https://stringi.gagolewski.com/rapi/about_search_regex.html}{about search: regex}} \cr
\ifelse{html}{\href{https://stringi.gagolewski.com/rapi/about_search_fixed.html}{\figure{aboutsearch-fixed-darkgreen.svg}{options: alt='[FIXED]'}}}{\href{https://stringi.gagolewski.com/rapi/about_search_fixed.html}{about search: fixed}} \cr
\ifelse{html}{\href{https://stringi.gagolewski.com/rapi/about_search_coll.html}{\figure{aboutsearch-coll-pink.svg}{options: alt='[COLL]'}}}{\href{https://stringi.gagolewski.com/rapi/about_search_coll.html}{about search: coll}} \cr
\ifelse{html}{\href{https://stringi.gagolewski.com/rapi/about_search_charclass.html}{\figure{aboutsearch-charclass-lightyellow.svg}{options: alt='[CHARCLASS]'}}}{\href{https://stringi.gagolewski.com/rapi/about_search_charclass.html}{about search: charclass}} \cr}

\item{brk}{a list with arguments to be send to \link[stringi]{stri_count_boundaries}. \cr
see also \link[stringi]{stri_opts_brkiter}. \cr
\ifelse{html}{\href{https://stringi.gagolewski.com/rapi/about_search_boundaries.html}{\figure{aboutsearch-boundaries-blue.svg}{options: alt='[BOUNDARIES]'}}}{\href{https://stringi.gagolewski.com/rapi/about_search_boundaries.html}{about search: boundaries}} \cr}
}
\value{
The \code{\%s+\%}, \code{\%s-\%}, and \code{\%s*\%} operators
return a character vector of the same length as \code{x}. \cr
The \code{\%s/\%} and \code{\%s//\%} both return an integer vector of the same length as \code{x}. \cr
The \code{\%s$\%} operator returns a character vector.
The \code{\%ss\%} operator returns a list of the split strings - or,
if \code{simplify = TRUE} / \code{simplify = NA},
returns a matrix of the split strings.
}
\description{
String arithmetic operators. \cr
\cr
The \code{ x \%s+\% y } operator is exported from 'stringi',
and concatenates character vectors \code{x} and \code{y}. \cr
\cr
The \code{ x \%s-\% p } operator removes character/pattern
defined in \code{p} from \code{x}. \cr
\cr
The \code{ x \%s*\% n } operator is exported from 'stringi',
and duplicates each string in \code{x} \code{n} times,
and concatenates the results. \cr
\cr
The \code{ x \%s/\% p } operator counts how often character/pattern
defined in \code{p} occurs in each element of \code{x}. \cr
\cr
The \code{ x \%s//\% brk } operator counts how often the text boundary specified in list \code{brk}
occurs in each element of \code{x}. \cr
\cr
The \code{ e1 \%s$\% e2 } operator is exported from 'stringi',
and provides access to \link[stringi]{stri_sprintf} in the form of an infix operator. \cr
\cr
The \code{ x \%ss\% p } operator splits the strings in \code{x}
by a delimiter character/pattern defined in \code{p},
and removes \code{p} in the process. \cr
For cutting strings by text boundaries, or around a location,
see \link{strcut_brk} and \link{strcut_loc}.
\cr
}
\examples{


x <- c(paste0(letters[1:13], collapse = ""),
       paste0(letters[14:26], collapse = ""))
print(x)
y <- c("a", "b")
p <- rep("a|e|i|o|u", 2) # same as p <- list(regex = rep("a|e|i|o|u", 2))
n <- c(3, 2)

x \%s+\% y # = paste0(x,y)
x \%s-\% p # remove all vowels from x
x \%s*\% n
x \%s/\% p # count how often vowels appear in each string of vector x
x \%ss\% p # split x around vowels, removing the vowels in the process
x \%ss\% s_regex(p, simplify = NA) # same as above, but in matrix form

test <- c(
paste0("The\u00a0above-mentioned    features are very useful. ",
"Spam, spam, eggs, bacon, and spam. 123 456 789"),
"good morning, good evening, and good night"
)
test \%s//\% list(type = "character")


x <- c(paste0(letters[1:13], collapse = ""),
       paste0(letters[14:26], collapse = ""))
print(x)
y <- "a"
# pattern that ignores case:
p <- list(regex = rep("A|E|I|O|U", 2), case_insensitive = TRUE)
n <- c(2, 3)

x \%s+\% y # = paste0(x,y)
x \%s-\% p # remove all vowels from x
x \%s*\% n
x \%s/\% p # count how often vowels appears in each string of vector x.

x <- c(paste(letters, collapse = ", "), paste(LETTERS, collapse = ", "))
print(x)
x \%ss\% ", "
t(x \%ss\% s_fixed(", ", simplify = NA))

}
\seealso{
\link{tinycodet_strings}
}
