% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/drawGraph.R
\name{drawGraph}
\alias{drawGraph}
\title{Draw graph function}
\usage{
drawGraph(draw_data)
}
\arguments{
\item{draw_data}{a data frame combining drug-target interaction data with drug sensitivity. The column names
must be upper case.}
}
\value{
An image in both pdf and nnf format of the estimated target inhibition network.
}
\description{
A function to draw the target inhibition network.
}
\examples{
\dontrun{
data(tyner_interaction_binary)
data(tyner_sensitivity)
y<-tyner_sensitivity[,1]
k_selected<-sffs(tyner_interaction_binary, y)$k_sel
x<-data.frame(tyner_interaction_binary[, k_selected])
#binarize the sensitivity data
one<-which(y>0.5)
zero<-which(y<=0.5)
SENS<-y
SENS[one]<-1
SENS[zero]<-0
draw_data<-cbind(x, SENS)
drawGraph(draw_data)
}
}
\author{
Jing Tang \email{jing.tang@helsinki.fi}
}
\references{
Tang J, Karhinen L, Xu T, Szwajda A, Yadav B, Wennerberg K, Aittokallio T.
Target inhibition networks: predicting selective combinations of druggable targets to block cancer
survival pathways. PLOS Computational Biology 2013; 9: e1003226.
}

