% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{addCustomTime}
\alias{addCustomTime}
\title{Add new vertical bar at a time point that can be dragged by the user}
\usage{
addCustomTime(id, time, itemId)
}
\arguments{
\item{id}{Timeline id}

\item{time}{The date/time to add}

\item{itemId}{The id of the custom time bar}
}
\description{
Add new vertical bar at a time point that can be dragged by the user
}
\examples{
if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    timevisOutput("timeline"),
    actionButton("btn", "Add time bar 24 hours ago")
  ),
  server = function(input, output) {
    output$timeline <- renderTimevis(
      timevis()
    )
    observeEvent(input$btn, {
      addCustomTime("timeline", Sys.Date() - 1, "yesterday")
    })
  }
)
}
}

