% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipes-step_slidify_augment.R
\name{step_slidify_augment}
\alias{step_slidify_augment}
\alias{tidy.step_slidify_augment}
\title{Slidify Rolling Window Transformation (Augmented Version)}
\usage{
step_slidify_augment(
  recipe,
  ...,
  period,
  .f,
  align = c("center", "left", "right"),
  partial = FALSE,
  prefix = "slidify_",
  role = "predictor",
  trained = FALSE,
  columns = NULL,
  f_name = NULL,
  skip = FALSE,
  id = rand_id("slidify_augment")
)

\method{tidy}{step_slidify_augment}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more numeric columns to be smoothed.
See \code{\link[recipes:selections]{recipes::selections()}} for more details.
For the \code{tidy} method, these are not currently used.}

\item{period}{The number of periods to include in the local rolling window.
This is effectively the "window size".}

\item{.f}{A summary \strong{formula} in one of the following formats:
\itemize{
\item \code{mean} with no arguments
\item \code{function(x) mean(x, na.rm = TRUE)}
\item \code{~ mean(.x, na.rm = TRUE)}, it is converted to a function.
}}

\item{align}{Rolling functions generate \code{period - 1} fewer values than the incoming vector.
Thus, the vector needs to be aligned. Alignment of the vector follows 3 types:
\itemize{
\item \strong{Center:} \code{NA} or \code{.partial} values are divided and added to the beginning and
end of the series to "Center" the moving average.
This is common for de-noising operations. See also \verb{[smooth_vec()]} for LOESS without NA values.
\item \strong{Left:} \code{NA} or \code{.partial} values are added to the end to shift the series to the Left.
\item \strong{Right:} \code{NA} or \code{.partial} values are added to the beginning to shif the series to the Right. This is common in
Financial Applications such as moving average cross-overs.
}}

\item{partial}{Should the moving window be allowed to return partial (incomplete) windows instead of NA values.
Set to FALSE by default, but can be switched to TRUE to remove NA's.}

\item{prefix}{A prefix for generated column names, default to "slidify_".}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the new variable columns created by the original variables
will be used as predictors in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument.}

\item{f_name}{A character string for the function being applied.
This field is a placeholder and will be populated during the \code{tidy()} step.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{bake.recipe()}? While all operations are baked
when \code{prep.recipe()} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_slidify_augment} object.}
}
\value{
For \code{step_slidify_augment}, an updated version of recipe with
the new step added to the sequence of existing steps (if any).
For the \code{tidy} method, a tibble with columns \code{terms}
(the selectors or variables selected), \code{value} (the feature
names).
}
\description{
\code{step_slidify_augment} creates a a \emph{specification} of a recipe
step that will "augment" (add multiple new columns) that have had a sliding function applied.
}
\details{
\strong{Alignment}

Rolling functions generate \code{period - 1} fewer values than the incoming vector.
Thus, the vector needs to be aligned. Alignment of the vector follows 3 types:
\itemize{
\item \strong{Center:} \code{NA} or \code{partial} values are divided and added to the beginning and
end of the series to "Center" the moving average.
This is common for de-noising operations. See also \verb{[smooth_vec()]} for LOESS without NA values.
\item \strong{Left:} \code{NA} or \code{partial} values are added to the end to shift the series to the Left.
\item \strong{Right:} \code{NA} or \code{partial} values are added to the beginning to shif the series to the Right. This is common in
Financial Applications such as moving average cross-overs.
}

\strong{Partial Values}
\itemize{
\item The advantage to using \code{partial} values vs \code{NA} padding is that
the series can be filled (good for time-series de-noising operations).
\item The downside to partial values is that the partials can become less stable
at the regions where incomplete windows are used.
}

If instability is not desirable for de-noising operations, a suitable alternative
is \code{\link[=step_smooth]{step_smooth()}}, which implements local polynomial regression.
}
\examples{
library(tidymodels)
library(dplyr)
library(timetk)

m750 <- m4_monthly \%>\%
    filter(id == "M750") \%>\%
    mutate(value_2 = value / 2)

m750_splits <- time_series_split(m750, assess = "2 years", cumulative = TRUE)

# Make a recipe
recipe_spec <- recipe(value ~ date + value_2, training(m750_splits)) \%>\%
    step_slidify_augment(
        value, value_2,
        period = c(6, 12, 24),
        .f = ~ mean(.x),
        align = "center",
        partial = FALSE
    )

recipe_spec \%>\% prep() \%>\% juice()

bake(prep(recipe_spec), testing(m750_splits))


}
\seealso{
Time Series Analysis:
\itemize{
\item Engineered Features: \code{\link[=step_timeseries_signature]{step_timeseries_signature()}}, \code{\link[=step_holiday_signature]{step_holiday_signature()}}, \code{\link[=step_fourier]{step_fourier()}}
\item Diffs & Lags \code{\link[=step_diff]{step_diff()}}, \code{recipes::step_lag()}
\item Smoothing: \code{\link[=step_slidify]{step_slidify()}}, \code{\link[=step_smooth]{step_smooth()}}
\item Variance Reduction: \code{\link[=step_box_cox]{step_box_cox()}}
\item Imputation: \code{\link[=step_ts_impute]{step_ts_impute()}}, \code{\link[=step_ts_clean]{step_ts_clean()}}
\item Padding: \code{\link[=step_ts_pad]{step_ts_pad()}}
}

Main Recipe Functions:
\itemize{
\item \code{recipes::recipe()}
\item \code{recipes::prep()}
\item \code{recipes::bake()}
}
}
\concept{moving_windows}
\concept{preprocessing}
\keyword{datagen}
