% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timer_class.R
\docType{class}
\name{timer}
\alias{timer}
\title{A R6 Class to represent a timer.}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
timer
}
\description{
timer is a R6 Class that represent a timer.
}
\section{Fields}{

\describe{
\item{\code{time}}{A POSIXct/POSIXlt value of your latest timing.}

\item{\code{event}}{A string of your latest timing.}

\item{\code{eventTable}}{A data frame that stores all timings.}

\item{\code{verbose}}{A printing setting that controls whether to print messages.}
}}

\section{Public Methods}{

\describe{
  \item{\code{initialize(time,event,verbose,eventTable)}
  }{Initialize a timer object. You can also use \code{createTimer()}
  function to initialize a timer object.}
  \item{\code{start(eventName)}
  }{Start timing for a event, \code{eventName} should be a string}
  \item{\code{stop(eventName)}
  }{Stop timing for a event.}
  \item{\code{getTimer()}
  }{Get a data frame that stores all recordings.You can also use
  \code{getTimer()} function to get the data frame.}
  \item{\code{removeEvent(eventName)}
  }{Remove an given row in the eventTable.}
  \item{\code{toggleVerbose()}
  }{Toggle between \code{TRUE} and \code{FALSE} for \code{verbose}}
  \item{\code{print()}
  }{Custom print method for timer class. However, you don't need to use this
  function to generate custom printing.
  Custom printing is triggered by default.}
  }
}

\section{Private Methods}{

\describe{
\item{\code{slprint(msg,flag = self$verbose)}
}{A function that controls whether to print extra message.}
}
}

\examples{
timer1 <- createTimer()
timer1$start("event1")
# put some codes in between
timer1$stop("event1")

timer1$start("event2")
# put some codes in between
timer1$stop("event2",comment = "event 2 completed")

table1 <- getTimer(timer1)
timer1$toggleVerbose() # set verbose to FALSE as default is TRUE

table1 # print all records in a tibble(data frame)
}
\keyword{datasets}
