\docType{package}
\name{tikzDevice-package}
\alias{tikzDevice}
\alias{tikzDevice-package}
\title{Support for native LaTeX output of R graphics}
\description{
The tikzDevice package implements the \code{\link{tikz}} ouput device which
generates R graphics in a LaTeX friendly format. LaTeX handles the
typesetting of all text in graphics generated by \code{tikz}. This allows
for seamless integration between these graphics and documents that are also
being typeset by LaTeX. Using LaTeX to generate graph text also means that
\strong{LaTeX mathematics can be typeset directly into labels and
annotations}.
}
\details{
\tabular{ll}{
  Package: \tab tikzDevice\cr
  Type: \tab Package\cr
  Version: \tab 0.7.0\cr
  Date: \tab 2013-12-10\cr
  License: \tab GPL 2 or greater\cr
  LazyLoad: \tab yes\cr
}
}
\section{Options That Affect Package Behavior}{
  The \pkg{tikzDevice} package is currently influenced by a
  number of global options that may be set in scripts, from
  the console or in a \code{.Rprofile} file. All of the
  options can be set by using \code{options(<option> =
  <value>)}.  These options allow for the use of custom
  \code{documentclass} declarations, LaTeX packages, and
  typesetting engines (e.g. XeLaTeX or LuaLaTeX). The
  defaults, if are any for a given option, are shown below
  the description. The global options are:

  \describe{

  \item{\code{tikzDefaultEngine}}{ Specifies which
  typesetting engine functions in the tikzDevice package
  will prefer. Current possible values are \code{pdftex},
  \code{xetex} or \code{luatex}. Respectively, these values
  trigger the use of the \code{pdflatex}, \code{xelatex}
  and \code{lualatex} compilers.  }

  \item{\code{tikzLatex}}{ Specifies the location of the
  LaTeX compiler to be used by \pkg{tikzDevice}. Setting
  this option may help the package locate a missing
  compiler. The default is searched for when the package is
  loaded, otherwise it can be set manually. This option may
  be set as follows: \code{options( tikzLatex =
  '/path/to/latex/compiler' )}.  }

  \item{\code{tikzXelatex}}{ Functions similar to
  \code{tikzLatex}, except this option specifies the
  location of the XeLaTeX compiler.  }

  \item{\code{tikzLualatex}}{ Functions similar to
  \code{tikzLatex}, except this option specifies the
  location of the LuaLaTeX compiler.  }

  \item{\code{tikzMetricsDictionary}}{ When using the
  graphics device provided by \pkg{tikzDevice}, you may
  notice that appears to ``lag" or ``hang" when commands
  such as \code{plot()} are executed. This is because the
  device must query the LaTeX compiler for string widths
  and font metrics. For a normal plot, this may happen
  dozens or hundreds of times- hence becomes unresponsive
  for a while. The good news is that the \code{\link{tikz}}
  code is designed to cache the results of these
  computations so they need only be performed once for each
  string or character. By default, these values are stored
  in a temporary cache file which is deleted when is shut
  down.  A location for a permanent cache file may be
  specified by setting the value of
  \code{tikzMetricsDictionary} in \code{.Rprofile} with
  \code{options(tikzMetricsDictionary =
  '/path/to/dictionary/location')}.  }

  \item{\code{tikzDocumentDeclaration}}{ A string. The
  LaTeX documentclass declaration used in output files when
  \code{standAlone == TRUE}. \code{tikzDocumentDeclaration}
  also influences the calculation of font metrics. The
  default value is:

  \preformatted{ options(tikzDocumentDeclaration =
  "\\documentclass[10pt]{article}") } }

  \item{\code{tikzLatexPackages}}{ A character vector.
  These are the packages which are included when using the
  \code{pdftex} engine and \code{\link{tikz}} is used with
  the the \code{standAlone} option as well as when font
  metrics are calculated.  }

  \item{\code{tikzXelatexPackages}}{ This option works like
  \code{tikzLatexPackages}, except is is used when the
  \code{xetex} engine is in use.  }

  \item{\code{tikzLualatexPackages}}{ This option works
  like \code{tikzXelatexPackages}, except is is used when
  the \code{luatex} engine is in use.  }

  \item{\code{tikzFooter}}{ A character vector. The footer
  to be used only when \code{standAlone==TRUE}.  }

  \item{\code{tikzMetricPackages}}{ A character vector.
  These are the packages which are additionally loaded when
  doing font metric calculations. As you see below, the
  font encoding is set to Type 1. This is very important so
  that character codes of LaTeX and match up. The default
  value is:

  \preformatted{ options(tikzMetricPackages = c(
  "\\usepackage[utf8]{inputenc}",
  "\\usepackage[T1]{fontenc}", "\\usetikzlibrary{calc}" ))
  } }

  \item{\code{tikzUnicodeMetricPackages}}{ This vector is
  used when font metric calculations are performed using
  the \code{xetex} or \code{luatex} engines. It should have
  the same contents as \code{tikzMetricPackages} with the
  addition of the \code{fontspec} and \code{xunicode}
  packages.  }

  \item{\code{tikzSanitizeCharacters}}{ A character vector
  of special latex characters to replace. These values
  should correspond to the replacement values from the
  \code{tikzReplacementCharacters} option. See
  \code{\link{sanitizeTexString}} for more details.  }

  \item{\code{tikzReplacementCharacters}}{ A character
  vector of replacements for special latex characters.
  These values should correspond to the values from the
  \code{tikzSanitizeCharacters} option.  }

  \item{\code{tikzRasterResolution}}{ When
  \code{\link{tikz}} is requested to add a raster to a
  graphic, the raster is written to a PNG file which is
  then included into the LaTeX code. This option controls
  the resolution (dpi) at which the PNG files are created.
  }

  \item{\code{tikzPdftexWarnUTF}}{ A \code{TRUE/FALSE}
  value that controls whether warnings are printed if
  Unicode characters are sent to a device using the
  \code{pdftex} engine.  } }

  Default values for all options may be viewed or restored
  using the \code{\link{setTikzDefaults}} function.
}
\author{
Cameron Bracken: \email{cameron.bracken@gmail.com}

Charlie Sharpsteen: \email{source@sharpsteen.net}

Yihui Xie: \email{xie@yihui.name}

Submit bug reports to: \url{https://github.com/yihui/tikzDevice/issues}
}
\references{
The TikZ and PGF Packages: Manual for version 2.00\cr
\url{http://sourceforge.net/projects/pgf}\cr Till Tanatu, February 20, 2008
}
\seealso{
\code{\link{tikz}}
}
\keyword{package}

