% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enumeration_units.R
\name{counties}
\alias{counties}
\title{Download a US Counties shapefile into R, and optionally subset by state}
\usage{
counties(state = NULL, cb = FALSE, resolution = "500k", year = NULL, ...)
}
\arguments{
\item{state}{The two-digit FIPS code (string) of the state you want, or a
vector of codes if you want multiple states. Can also be state name
or state abbreviation.}

\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
counties file.  Defaults to FALSE (the most detailed TIGER file).}

\item{resolution}{The resolution of the cartographic boundary file (if cb == TRUE).
Defaults to '500k'; options include '5m' (1:5 million) and '20m' (1:20 million).}

\item{year}{the data year; defaults to 2021}

\item{...}{arguments to be passed to internal function \code{load_tiger}, which is not exported. See Additional Arguments.}
}
\description{
Description from the US Census Bureau (see link for source):
The primary legal divisions of most states are termed counties. In Louisiana,
these divisions are known as parishes.  In Alaska, which has no counties,
the equivalent entities are the organized boroughs, city and boroughs,
municipalities, and census areas; the latter of which are delineated
cooperatively for statistical purposes by the state of Alaska and the
Census Bureau.  In four states (Maryland, Missouri, Nevada, and Virginia),
there are one or more incorporated places that are independent of any county
organization and thus constitute primary divisions of their states.  These
incorporated places are known as independent cities and are treated as
equivalent entities for purposes of data presentation.  The District of
Columbia and Guam have no primary divisions, and each area is considered
an equivalent entity for purposes of data presentation.  All of the counties
in Connecticut and Rhode Island and nine counties in Massachusetts were
dissolved as functioning governmental entities; however, the Census Bureau
continues to present data for these historical entities in order to provide
comparable geographic units at the county level of the geographic hierarchy
for these states and represents them as nonfunctioning legal entities in
data products.  The Census Bureau treats the following entities as
equivalents of counties for purposes of data presentation: municipios in
Puerto Rico, districts and islands in American Samoa, municipalities in the
Commonwealth of the Northern Mariana Islands, and islands in the U.S.
Virgin Islands.  Each county or statistically equivalent entity is assigned
a three-character numeric Federal Information Processing Series (FIPS) code
based on alphabetical sequence that is unique within state and an
eight-digit National Standard feature identifier.
}
\section{Additional Arguments}{

Additional arguments that can be passed in \code{...} are:
\itemize{
\item \code{class} Desired class of return object: \code{"sf"} (the default) or \code{"sp"}.  sp classes should be considered deprecated as of tigris version 2.0, but legacy support is still available.
\item \code{progress_bar} If set to \code{FALSE}, do not display download progress bar (helpful for R Markdown documents). Defaults to \code{TRUE}.
\item \code{keep_zipped_shapefile} If set to \code{TRUE}, do not delete zipped shapefile (stored in temporary directory or \code{TIGRIS_CACHE_DIR}
depending on the configuration of global option \code{"tigris_use_cache"}). Defaults to \code{FALSE}.
\item \code{refresh} Whether to re-download cached shapefiles (\code{TRUE} or \code{FALSE}) . The default is either \code{FALSE} or the value of global
option \code{"tigris_refresh"} if it is set. Specifying this argument will override the behavior set in \code{"tigris_refresh"} global option.
\item \code{filter_by} Geometry used to filter the output returned by the function.  Can be an sf object, an object of class \code{bbox}, or a length-4 vector of format \code{c(xmin, ymin, xmax, ymax)} that can be converted to a bbox. Geometries that intersect the input to \code{filter_by} will be returned.
}
}

\examples{
\dontrun{
library(tigris)
library(ggplot2)

me <- counties("Maine", cb = TRUE)

gg <- ggplot()
gg <- gg + geom_sf(data = me, color="black",
                   fill="white", size=0.25)
gg
}
}
\seealso{
\url{https://www2.census.gov/geo/pdfs/reference/GARM/Ch4GARM.pdf}

Other general area functions: 
\code{\link{block_groups}()},
\code{\link{blocks}()},
\code{\link{county_subdivisions}()},
\code{\link{places}()},
\code{\link{pumas}()},
\code{\link{school_districts}()},
\code{\link{states}()},
\code{\link{tracts}()},
\code{\link{zctas}()}
}
\concept{general area functions}
