% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_game.R
\name{make_game}
\alias{make_game}
\title{Play with a Discrete Random Variable}
\usage{
make_game(outcomes, probs, plays)
}
\arguments{
\item{outcomes}{numerical vector of possible values of the random variable}

\item{probs}{numerical vector giving the probability distribution}

\item{plays}{number of times the random variable is simulated}
}
\value{
a function of a single parameter n, with default value 1.
n is the number of times you simulate the net winnings.
}
\description{
Makes a function that simulates a game based where
your winnings are the sum of a specified number of plays of a
discrete random variable with a specified distribution.
}
\examples{
\dontrun{
play_game <- make_gmae(
  outcomes = c(-1, 0, 5)
  probs = c(0.4, 0.5, 0.1)
  plays = 2000
)
## Play "plays" times, get net winnings:
sampler()
## Play "plays" times again:
sampler()
## Play "plays" times, a third time:
sampler()
## 1000 more simulations of the net winnings:
sampler(n = 1000)
}
}
\author{
Homer White \email{hwhite0@georgetowncollege.edu}
}
