% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_caching.R
\name{tw_set_cache_db}
\alias{tw_set_cache_db}
\title{Set database connection settings for the session}
\usage{
tw_set_cache_db(
  db_settings = NULL,
  driver = NULL,
  host = NULL,
  port,
  database,
  user,
  pwd
)
}
\arguments{
\item{db_settings}{A list of database connection settings (see example)}

\item{driver}{A database driver. Common database drivers include \code{MySQL}, \code{PostgreSQL}, and \code{MariaDB}. See \code{unique(odbc::odbcListDrivers()[[1]])} for a list of locally available drivers.}

\item{host}{Host address, e.g. "localhost".}

\item{port}{Port to use to connect to the database.}

\item{database}{Database name.}

\item{user}{Database user name.}

\item{pwd}{Password for the database user.}
}
\value{
A list with all given parameters (invisibly).
}
\description{
Set database connection settings for the session
}
\examples{
\donttest{
if (interactive()) {

  # Settings can be provided either as a list
  db_settings <- list(
    driver = "MySQL",
    host = "localhost",
    port = 3306,
    database = "tidywikidatar",
    user = "secret_username",
    pwd = "secret_password"
  )

  tw_set_cache_db(db_settings)

  # or as parameters

  tw_set_cache_db(
    driver = "MySQL",
    host = "localhost",
    port = 3306,
    database = "tidywikidatar",
    user = "secret_username",
    pwd = "secret_password"
  )
}
}
}
