% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get.R
\name{tw_get_property_description}
\alias{tw_get_property_description}
\title{Get description of a Wikidata property in a given language}
\usage{
tw_get_property_description(
  property,
  language = "en",
  cache = NULL,
  overwrite_cache = FALSE,
  wait = 0
)
}
\arguments{
\item{property}{A characther vector of length 1, must start with P, e.g. "P31".}

\item{language}{A character vector of length one, defaults to "en". For a full list of available values, see: https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}

\item{cache}{Defaults to NULL. If given, it should be given either TRUE or FALSE. Typically set with \code{tw_enable_cache()} or \code{tw_disable_cache()}.}

\item{overwrite_cache}{Logical, defaults to FALSE. If TRUE, it overwrites the table in the local sqlite database. Useful if the original Wikidata object has been updated.}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to Wikidata. If data are cached locally, wait time is not applied. If you are running many queries systematically you may want to add some waiting time between queries.}
}
\value{
A charachter vector of length 1, with the Wikidata label in the requested languae.
}
\description{
Get description of a Wikidata property in a given language
}
\examples{
tw_get_property_description(property = "P31")
}
