% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solvect_chlorine.R
\name{solvect_chlorine_once}
\alias{solvect_chlorine_once}
\title{Apply `solvect_chlorine` to a data frame and create new columns with ct and log removals.}
\usage{
solvect_chlorine_once(
  df,
  input_water = "defined_water",
  time = 0,
  residual = 0,
  baffle = 0,
  water_prefix = TRUE
)
}
\arguments{
\item{df}{a data frame containing a water class column, which has already been computed using \code{\link{define_water_chain}}}

\item{input_water}{name of the column of Water class data to be used as the input for this function. Default is "defined_water".}

\item{time}{Retention time of disinfection segment in minutes.}

\item{residual}{Minimum chlorine residual in disinfection segment in mg/L as Cl2.}

\item{baffle}{Baffle factor - unitless value between 0 and 1.}

\item{water_prefix}{name of the input water used for the calculation will be appended to the start of output columns. Default is TRUE.}
}
\value{
A data frame containing the original data frame and columns for required CT, actual CT, and giardia log removal.
}
\description{
This function allows \code{\link{solvect_chlorine}} to be added to a piped data frame.
Three additional columns will be added to the data frame; ct_required (mg/L*min), ct_actual (mg/L*min), glog_removal
}
\details{
The data input comes from a `water` class column, initialized in \code{\link{define_water_chain}}.

 For large datasets, using `fn_once` or `fn_chain` may take many minutes to run. These types of functions use the furrr package
 for the option to use parallel processing and speed things up. To initialize parallel processing, use
 `plan(multisession)` or `plan(multicore)` (depending on your operating system) prior to your piped code with the
 `fn_once` or `fn_chain` functions. Note, parallel processing is best used when your code block takes more than a minute to run,
 shorter run times will not benefit from parallel processing.
}
\examples{
library(dplyr)
ct_calc <- water_df \%>\%
  define_water_chain() \%>\%
  solvect_chlorine_once(residual = 2, time = 10)

ozone_resid <- water_df \%>\%
  mutate(br = 50) \%>\%
  define_water_chain() \%>\%
  mutate(
    residual = seq(1, 12, 1),
    time = seq(2, 24, 2),
    baffle = 0.7
  ) \%>\%
  solvect_chlorine_once()

}
