% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpcstats.R
\name{predcorrect}
\alias{predcorrect}
\alias{predcorrect.tidyvpcobj}
\title{predcorrect}
\usage{
predcorrect(o, ...)

\method{predcorrect}{tidyvpcobj}(o, pred, data = o$data, ..., log = FALSE)
}
\arguments{
\item{o}{tidyvpc object}

\item{...}{Other arguments to include}

\item{pred}{prediction variable in observed data}

\item{data}{observed data supplied in \code{observed()} function}

\item{log}{logical indicating whether DV was modeled in logarithimic scale}
}
\value{
Updates \code{tidyvpcobj} with required information to performing prediction correction which include \code{predcor} logical indicating whether
  prediction corrected VPC is to be performed, \code{predcor.log} logical indicating whether the DV is on a log-scale, and the \code{pred} prediction
  column from the original data.
}
\description{
Prediction corrected Visual Predictive Check (pcVPC)
}
\details{
Specify prediction variable for pcVPC
}
\examples{

obs_data <- data.table::as.data.table(tidyvpc::obs_data)
sim_data <- data.table::as.data.table(tidyvpc::sim_data)

obs_data <- obs_data[MDV == 0]
sim_data <- sim_data[MDV == 0]

 # Add PRED variable to observed data from first replicate of 
 # simulated data
 
obs_data$PRED <- sim_data[REP == 1, PRED]

  vpc <- observed(obs_data, x=TIME, y=DV) \%>\%
       simulated(sim_data, y=DV) \%>\%
       binning(bin = NTIME) \%>\%
       predcorrect(pred=PRED) \%>\%
       vpcstats()
       
 \donttest{    
 # For binless loess prediction corrected, use predcorrect() before 
 # binless() and set loess.ypc = TRUE
 
  vpc <- observed(obs_data, x=TIME, y=DV) \%>\%
       simulated(sim_data, y=DV) \%>\%
       predcorrect(pred=PRED) \%>\%
       binless(loess.ypc = TRUE) \%>\%
       vpcstats()
       }
       
}
\seealso{
\code{\link{observed}} \code{\link{simulated}} \code{\link{censoring}} \code{\link{stratify}} \code{\link{binning}} \code{\link{binless}} \code{\link{vpcstats}}
}
