% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_available.R
\name{tt_available}
\alias{tt_available}
\alias{tt_datasets}
\title{Listing all available TidyTuesdays}
\usage{
tt_available(auth = gh::gh_token())

tt_datasets(year, auth = gh::gh_token())
}
\arguments{
\item{auth}{A GitHub token. See \code{\link[gh:gh_token]{gh::gh_token()}} for more details.}

\item{year}{What year of TidyTuesday to use}
}
\value{
\code{tt_available()} returns a \code{tt_dataset_table_list}, which is a
list of \code{tt_dataset_table}. This class has special printing methods to show
the available data sets.

\code{tt_datasets()} returns a \code{tt_dataset_table} object. This class has
special printing methods to show the available datasets for the year.
}
\description{
The TidyTuesday project is a constantly growing repository of data sets.
Knowing what type of data is available for each week requires going to the
source. However, one of the hallmarks of 'tidytuesdayR' is that you never
have to leave your R console. These functions were
created to help maintain this philosophy.
}
\details{
To find out the available datasets for a specific year, the user
can use the function \code{tt_datasets()}. This function will either populate the
Viewer or print to console all the available data sets and the week/date
they are associated with.

To get the whole list of all the data sets ever released by TidyTuesday, the
function \code{tt_available()} was created. This function will either populate the
Viewer or print to console all the available data sets ever made for
TidyTuesday.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# check to make sure there are requests still available
if (rate_limit_check(quiet = TRUE) > 30) {
  ## show data available from 2018
  tt_datasets(2018)

  ## show all data available ever
  tt_available()
}
\dontshow{\}) # examplesIf}
}
