% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glimpse-Spat.R
\name{glimpse.Spat}
\alias{glimpse.Spat}
\alias{glimpse.SpatRaster}
\alias{glimpse.SpatVector}
\title{Get a glimpse of your Spat* objects}
\usage{
\method{glimpse}{SpatRaster}(x, width = NULL, ...)

\method{glimpse}{SpatVector}(x, width = NULL, ...)
}
\arguments{
\item{x}{A SpatRaster created with \code{\link[terra:rast]{terra::rast()}} or a SpatVector
created with \code{\link[terra:vect]{terra::vect()}}.}

\item{width}{Width of output: defaults to the setting of the
\code{width} if finite (see \code{\link[dplyr:glimpse]{dplyr::glimpse()}}) or the width of the console.}

\item{...}{Arguments passed on to \code{\link[=as_tibble.Spat]{as_tibble()}} Spat
methods.}
}
\value{
original \code{x} is (invisibly) returned, allowing \code{glimpse()} to
be used within a data pipeline.
}
\description{
\code{glimpse()} is like a transposed version of \code{\link[=print]{print()}}: layers/columns run
down the  page, and data runs across. This makes it possible to see every
layer/column in a Spat* object.
}
\section{terra equivalent}{


\code{print()}
}

\section{Methods}{


Implementation of the \strong{generic} \code{\link[dplyr:glimpse]{dplyr::glimpse()}} function for
Spat*. objects.
}

\examples{

library(terra)

# SpatVector
v <- vect(system.file("extdata/cyl.gpkg", package = "tidyterra"))

v \%>\% glimpse(width = 200)

# Use on a pipeline
v \%>\%
  glimpse() \%>\%
  mutate(a = 30) \%>\%
  # with options
  glimpse(geom = "WKT")

# SpatRaster
r <- rast(system.file("extdata/cyl_elev.tif", package = "tidyterra"))

r \%>\% glimpse()

# Use on a pipeline
r \%>\%
  glimpse() \%>\%
  mutate(b = elevation_m / 100) \%>\%
  # With options
  glimpse(xy = TRUE)
}
\seealso{
\code{\link[dplyr:glimpse]{dplyr::glimpse()}}

Other dplyr verbs that operate on columns:
\code{\link{mutate.Spat}},
\code{\link{pull.Spat}},
\code{\link{relocate.Spat}},
\code{\link{rename.Spat}},
\code{\link{select.Spat}}

Other dplyr methods:
\code{\link{arrange.SpatVector}()},
\code{\link{bind_cols.SpatVector}},
\code{\link{bind_rows.SpatVector}},
\code{\link{count.SpatVector}()},
\code{\link{distinct.SpatVector}()},
\code{\link{filter-joins.SpatVector}},
\code{\link{filter.Spat}},
\code{\link{group-by.SpatVector}},
\code{\link{mutate-joins.SpatVector}},
\code{\link{mutate.Spat}},
\code{\link{pull.Spat}},
\code{\link{relocate.Spat}},
\code{\link{rename.Spat}},
\code{\link{rowwise.SpatVector}()},
\code{\link{select.Spat}},
\code{\link{slice.Spat}},
\code{\link{summarise.SpatVector}()}
}
\concept{dplyr.cols}
\concept{dplyr.methods}
