% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_extract_tidy.R
\name{ee_extract_tidy}
\alias{ee_extract_tidy}
\title{ee_extract_tidy}
\usage{
ee_extract_tidy(
  x,
  y,
  stat = "mean",
  scale,
  via = "getInfo",
  container = "rgee_backup",
  sf = TRUE,
  lazy = FALSE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{x}{tidyee, ee$Image, or ee$ImageCollection}

\item{y}{sf or ee$feature or ee$FeatureCollection}

\item{stat}{zonal stat ("mean", "median" , "min","max" etc)}

\item{scale}{A nominal scale in meters of the Image projection to work in. By default 1000.}

\item{via}{Character. Method to export the image. Three method are implemented: "getInfo", "drive", "gcs".}

\item{container}{Character. Name of the folder ('drive') or bucket ('gcs') to be exported into (ignore if via is not defined as "drive" or "gcs").}

\item{sf}{Logical. Should return an sf object?}

\item{lazy}{Logical. If TRUE, a future::sequential object is created to evaluate the task in the future. Ignore if via is set as "getInfo". See details.}

\item{quiet}{Logical. Suppress info message.}

\item{...}{additional parameters}
}
\value{
data.frame in long format with point estimates for each time-step and y feature based on statistic provided
}
\description{
ee_extract_tidy
}
\examples{
\dontrun{
library(rgee)
library(tidyrgee)
ee_Initizialize()
modis_ic <- ee$ImageCollection("MODIS/006/MOD13Q1")
point_sample_buffered <- tidyrgee::bgd_msna |>
    sample_n(3) |>
    sf::st_as_sf(coords=c("_gps_reading_longitude",
                       "_gps_reading_latitude"), crs=4326) |>
    sf::st_transform(crs=32646) |>
    sf::st_buffer(dist = 500) |>
    dplyr::select(`_uuid`)
modis_ic_tidy <- as_tidyee(modis_ic)
modis_monthly_baseline_mean <- modis_ic_tidy |>
 select("NDVI") |>
 filter(year \%in\% 2000:2015) |>
  group_by(month) |>
 summarise(stat="mean")

ndvi_monthly_mean_at_pt<- modis_monthly_baseline_mean |>
   ee_extract(y = point_sample_buffered,
            fun="mean",
            scale = 500)
}
}
\seealso{
\code{\link[rgee]{ee_extract}} for information about ee_extract on ee$ImageCollections and ee$Images
}
