% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest.R
\name{unnest}
\alias{unnest}
\title{Unnest a list column.}
\usage{
unnest(data, ..., .drop = NA, .id = NULL, .sep = NULL)
}
\arguments{
\item{data}{A data frame.}

\item{...}{Specification of columns to nest. Use bare variable names or
functions of variables. If omitted, defaults to all list-cols.}

\item{.drop}{Should additional list columns be dropped? By default,
\code{unnest} will drop them if unnesting the specified columns requires
the rows to be duplicated.}

\item{.id}{Data frame idenfier - if supplied, will create a new column
with name \code{.id}, giving a unique identifer. This is most useful if
the list column is named.}

\item{.sep}{If non-\code{NULL}, the names of unnested data frame columns
will combine the name of the original list-col with the names from
nested data frame, separated by \code{.sep}.}
}
\description{
If you have a list-column, this makes each element of the list its own
row. List-columns can either be atomic vectors or data frames. Each
row must have the same number of entries.
}
\examples{
library(dplyr)
df <- data_frame(
  x = 1:3,
  y = c("a", "d,e,f", "g,h")
)
df \%>\%
  transform(y = strsplit(y, ",")) \%>\%
  unnest(y)

# Or just
df \%>\%
  unnest(y = strsplit(y, ","))

# It also works if you have a column that contains other data frames!
df <- data_frame(
  x = 1:2,
  y = list(
   data_frame(z = 1),
   data_frame(z = 3:4)
 )
)
df \%>\% unnest(y)

# You can also unnest multiple columns simultaneously
df <- data_frame(
 a = list(c("a", "b"), "c"),
 b = list(1:2, 3),
 c = c(11, 22)
)
df \%>\% unnest(a, b)
# If you omit the column names, it'll unnest all list-cols
df \%>\% unnest()

# Nest and unnest are inverses
df <- data.frame(x = c(1, 1, 2), y = 3:1)
df \%>\% nest(y)
df \%>\% nest(y) \%>\% unnest()

# If you have a named list-column, you may want to supply .id
df <- data_frame(
  x = 1:2,
  y = list(a = 1, b = 3:4)
)
unnest(df, .id = "name")
}
\seealso{
\code{\link{nest}} for the inverse operation.

\code{\link{unnest_}} for a version that uses regular evaluation
  and is suitable for programming with.
}
