% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_loci_if.R
\name{select_loci_if}
\alias{select_loci_if}
\title{The \code{select_if} verb for \code{loci}}
\usage{
select_loci_if(.data, .sel_logical)
}
\arguments{
\item{.data}{a \code{gen_tibble}}

\item{.sel_logical}{a logical vector of length equal to the number of loci,
or an expression that will tidy evaluate to such a vector. Only loci
for which .sel_logical is TRUE will be selected; NA will be treated as FALSE.}
}
\value{
a subset of the list of loci in the \code{gen_tibble}
}
\description{
An equivalent to \code{\link[dplyr:select_all]{dplyr::select_if()}} that works on the \code{genotype} column
of a \code{gen_tibble}. This function has access to the genotypes (and thus can
work on summary statistics to select), but not the names of the loci (look
at \code{\link[=select_loci]{select_loci()}} for that feature.
}
\details{
Note that the \code{select_loci_if} verb does not modify the backing FBM files,
but rather it subsets the list of loci to be used stored in the \code{gen_tibble}.
}
\examples{
example_gt <- load_example_gt("gen_tbl")

# Select loci by chromosome
example_gt_subset <- example_gt \%>\%
  select_loci_if(loci_chromosomes(genotypes) == "chr2")
show_loci(example_gt_subset)

# Select loci by a summary statistic
example_gt_subset <- example_gt \%>\%
  select_loci_if(loci_maf(genotypes) > 0.2)
show_loci(example_gt_subset)

}
\seealso{
\code{\link[dplyr:select_all]{dplyr::select_if()}}
}
