% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_as_hierfstat.R
\name{gt_as_hierfstat}
\alias{gt_as_hierfstat}
\title{Convert a \code{gen_tibble} to a data.frame compatible with \code{hierfstat}}
\usage{
gt_as_hierfstat(x)
}
\arguments{
\item{x}{a \code{\link{gen_tibble}}, with population coded as 'population'}
}
\value{
a data.frame with a column 'pop' and further column representing
the genotypes (with alleles recoded as 1 and 2)
}
\description{
This function converts a \code{gen_tibble} to a data.frame formatted
to be used by \code{hierfstat} functions.
}
\examples{
example_gt <- load_example_gt("gen_tbl")

# Convert to genind
gt_hierfstat <- example_gt \%>\% gt_as_hierfstat()

# Check object class
class(gt_hierfstat)
}
