% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_openai.R
\name{openai_chat}
\alias{openai_chat}
\title{Send LLM Messages to the OpenAI Chat Completions API}
\usage{
openai_chat(
  .llm,
  .model = "gpt-4o",
  .max_completion_tokens = NULL,
  .reasoning_effort = NULL,
  .frequency_penalty = NULL,
  .logit_bias = NULL,
  .presence_penalty = NULL,
  .seed = NULL,
  .stop = NULL,
  .stream = FALSE,
  .temperature = NULL,
  .top_p = NULL,
  .api_url = "https://api.openai.com/",
  .timeout = 60,
  .verbose = FALSE,
  .json_schema = NULL,
  .max_tries = 3,
  .dry_run = FALSE,
  .compatible = FALSE,
  .api_path = "/v1/chat/completions",
  .logprobs = NULL,
  .top_logprobs = NULL,
  .tools = NULL,
  .tool_choice = NULL
)
}
\arguments{
\item{.llm}{An \code{LLMMessage} object containing the conversation history.}

\item{.model}{The identifier of the model to use (default: "gpt-4o").}

\item{.max_completion_tokens}{An upper bound for the number of tokens that can be generated for a completion, including visible output tokens and reasoning tokens.}

\item{.reasoning_effort}{How long should reasoning models reason (can either be "low","medium" or "high")}

\item{.frequency_penalty}{Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far.}

\item{.logit_bias}{A named list modifying the likelihood of specified tokens appearing in the completion.}

\item{.presence_penalty}{Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far.}

\item{.seed}{If specified, the system will make a best effort to sample deterministically.}

\item{.stop}{Up to 4 sequences where the API will stop generating further tokens.}

\item{.stream}{If set to TRUE, the answer will be streamed to console as it comes (default: FALSE).}

\item{.temperature}{What sampling temperature to use, between 0 and 2. Higher values make the output more random.}

\item{.top_p}{An alternative to sampling with temperature, called nucleus sampling.}

\item{.api_url}{Base URL for the API (default: "https://api.openai.com/").}

\item{.timeout}{Request timeout in seconds (default: 60).}

\item{.verbose}{Should additional information be shown after the API call (default: FALSE).}

\item{.json_schema}{A JSON schema object provided by tidyllm schema or ellmer schemata.}

\item{.max_tries}{Maximum retries to perform request}

\item{.dry_run}{If TRUE, perform a dry run and return the request object (default: FALSE).}

\item{.compatible}{If TRUE, skip API and rate-limit checks for OpenAI compatible APIs (default: FALSE).}

\item{.api_path}{The path relative to the base \code{.api_url} for the API (default: "/v1/chat/completions").}

\item{.logprobs}{If TRUE, get the log probabilities of each output token (default: NULL).}

\item{.top_logprobs}{If specified, get the top N log probabilities of each output token (0-5, default: NULL).}

\item{.tools}{Either a single TOOL object or a list of TOOL objects representing the available functions for tool calls.}

\item{.tool_choice}{A character string specifying the tool-calling behavior; valid values are "none", "auto", or "required".}
}
\value{
A new \code{LLMMessage} object containing the original messages plus the assistant's response.
}
\description{
This function sends a message history to the OpenAI Chat Completions API and returns the assistant's reply.
}
