#' Table imputation methods
#' 
#' Replace missing value methods with a variety of methods 
#' 
#' @param .tbl table-like or list-like structure
#' @param .na value/function to be used for replacement
#' @param .vars list of columns generated by vars(), or a character vector of 
#'        column names, or a numeric vector of column positions.
#' @param .predicate A predicate function to be applied to the columns or a 
#'         logical vector. 
#' @param ... addition passed to the imputation method
#' 
#' @details 
#' 
#' These methods are modelled closely after [dplyr::mutate()] and the select 
#' style verbs. Most of the functions depend on the **na.tools** package.
#' 
#' Function List:
#'  * explicit: `impute_explicit`, `impute_explicit_at`, `impute_explicit_all`, `impute_explicit_if`
#'  * zero: `impute_zero`, `impute_zero_at`, `impute_zero_all`, `impute_zero_if`
#'  * inf: `impute_inf`, `impute_inf_at`, `impute_inf_all`, `impute_inf_if`
#'  * neginf: `impute_neginf`, `impute_neginf_at`, `impute_neginf_all`, `impute_neginf_if`
#'  * constant: `impute_constant`, `impute_constant_at`, `impute_constant_all`, `impute_constant_if`
#'  
#'  * max: `impute_max`, `impute_max_at`, `impute_max_all`, `impute_max_if`
#'  * min: `impute_min`, `impute_min_at`, `impute_min_all`, `impute_min_if`
#'  * median: `impute_median`, `impute_median_at`, `impute_median_all`, `impute_median_if`
#'  * mean: `impute_mean`, `impute_mean_at`, `impute_mean_all`, `impute_mean_if`
#'  * most_freq: `impute_most_freq`, `impute_most_freq_at`, `impute_most_freq_all`, `impute_most_freq_if`
#'  * quantile: `impute_quantile`, `impute_quantile_at`, `impute_quantile_all`, `impute_quantile_if`
#'  * sample: `impute_sample`, `impute_sample_at`, `impute_sample_all`, `impute_sample_if`
#'  * random: `impute_random`, `impute_random_at`, `impute_random_all`, `impute_random_if`
#'  * replace: `impute_replace`, `impute_replace_at`, `impute_replace_all`, `impute_replace_if`
#' 
#' @examples 
#' 
#'  \dontrun{ 
#'   nacars %>% impute_zero() 
#'   nacars %>% impute_zero( mpg, cyl )
#'   nacars %>% impute_zero( "mpg", "cyl" )
#'   nacars %>% impute_zero( c("mpg","cyl") )
#'   nacars %>% impute_zero( 1:2 )
#'  }
#' @md
#' @rawNamespace exportPattern("^impute_.*$")
#' @include utils.R make_impute.R
#' @aliases 
#'  impute_explicit impute_explicit_at impute_explicit_all impute_explicit_if
#'  impute_zero impute_zero_at impute_zero_all impute_zero_if
#'  impute_inf impute_inf_at impute_inf_all impute_inf_if
#'  impute_neginf impute_neginf_at impute_neginf_all impute_neginf_if
#'  impute_constant impute_constant_at impute_constant_all impute_constant_if
#'  impute_max impute_max_at impute_max_all impute_max_if
#'  impute_min impute_min_at impute_min_all impute_min_if
#'  impute_median impute_median_at impute_median_all impute_median_if
#'  impute_mean impute_mean_at impute_mean_all impute_mean_if
#'  impute_most_freq impute_most_freq_at impute_most_freq_all impute_most_freq_if
#'  impute_quantile impute_quantile_at impute_quantile_all impute_quantile_if
#'  impute_sample impute_sample_at impute_sample_all impute_sample_if
#'  impute_random impute_random_at impute_random_all impute_random_if
#'  impute_replace impute_replace_at impute_replace_all impute_replace_if
#' @importFrom stats na.pass
#' @importFrom methods as
#' @rdname impute_functions

impute_functions <- function( .tbl, .na, .vars, .predicate ) {} # just a stub

assign_these( make_imputes(na.explicit) )

assign_these( make_imputes(na.zero) ) 
assign_these( make_imputes(na.inf) )
assign_these( make_imputes(na.neginf) )
assign_these( make_imputes(na.constant) )


assign_these( make_imputes(na.max) )
assign_these( make_imputes(na.min) )
assign_these( make_imputes(na.mean) )
assign_these( make_imputes(na.median) )
assign_these( make_imputes(na.most_freq) )
assign_these( make_imputes(na.quantile) )

assign_these( make_imputes(na.sample) )
assign_these( make_imputes(na.random) )
assign_these( make_imputes(na.replace) )
