% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hy.R
\name{hy_stn_remarks}
\alias{hy_stn_remarks}
\title{Extract station remarks from HYDAT database}
\format{
A tibble with 4 variables:
\describe{
  \item{STATION_NUMBER}{Unique 7 digit Water Survey of Canada station number}
  \item{REMARK_TYPE}{Type of Remark}
  \item{Year}{Year of the remark}
  \item{REMARK}{Remark}
}
}
\usage{
hy_stn_remarks(
  station_number = NULL,
  hydat_path = NULL,
  prov_terr_state_loc = NULL
)
}
\arguments{
\item{station_number}{A seven digit Water Survey of Canada station number. If this argument is omitted, the value of \code{prov_terr_state_loc}
is returned.}

\item{hydat_path}{The path to the hydat database or NULL to use the default location
used by \link{download_hydat}. It is also possible to pass in an existing 
\link[dplyr]{src_sqlite} such that the database only needs to be opened once per
user-level call.}

\item{prov_terr_state_loc}{Province, state or territory. If this argument is omitted, the value of \code{station_number}
is returned. See \code{unique(allstations$prov_terr_state_loc)}. Will also accept \code{CA} to return only Canadian stations.}
}
\value{
A tibble of hy_stn_remarks
}
\description{
hy_stn_remarks look-up Table
}
\examples{
\dontrun{
hy_stn_remarks(station_number = c("02JE013","08MF005"))
}

}
