% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hy_stn_regulation.R
\name{hy_stn_regulation}
\alias{hy_stn_regulation}
\title{Extract station regulation from the HYDAT database}
\format{A tibble with 4 variables:
\describe{
  \item{STATION_NUMBER}{Unique 7 digit Water Survey of Canada station number}
  \item{YEAR_FROM}{First year of use}
  \item{YEAR_TO}{Last year of use}
  \item{REGULATED}{logical}
}}
\source{
HYDAT
}
\usage{
hy_stn_regulation(station_number = NULL, hydat_path = NULL,
  prov_terr_state_loc = NULL)
}
\arguments{
\item{station_number}{A seven digit Water Survey of Canada station number. If this argument is omitted, the value of \code{prov_terr_state_loc}
is returned.}

\item{hydat_path}{The default for this argument is to look for hydat in the same location where it
was saved by using \code{download_hydat}. Therefore this argument is almost always omitted from a function call. 
You can see where hydat was downloaded using \code{hy_dir()}}

\item{prov_terr_state_loc}{Province, state or territory. If this argument is omitted, the value of \code{station_number}
is returned. See \code{unique(allstations$prov_terr_state_loc)}}
}
\value{
A tibble of stations, years of regulation and the regulation status
}
\description{
Provides wrapper to turn the hy_stn_regulation table in HYDAT into a tidy data frame of station regulation. 
\code{station_number} and \code{prov_terr_state_loc} can both be supplied. If both are omitted all values 
from the \code{hy_stations} table are returned.
}
\examples{
\dontrun{
## Multiple stations province not specified
hy_stn_regulation(station_number = c("08NM083","08NE102"))

## Multiple province, station number not specified
hy_stn_regulation(prov_terr_state_loc = c("AB","YT"))
}

}
\seealso{
Other HYDAT functions: \code{\link{hy_agency_list}},
  \code{\link{hy_annual_instant_peaks}},
  \code{\link{hy_annual_stats}},
  \code{\link{hy_daily_flows}},
  \code{\link{hy_daily_levels}},
  \code{\link{hy_data_symbols}},
  \code{\link{hy_data_types}}, \code{\link{hy_datum_list}},
  \code{\link{hy_monthly_flows}},
  \code{\link{hy_monthly_levels}},
  \code{\link{hy_reg_office_list}},
  \code{\link{hy_sed_daily_loads}},
  \code{\link{hy_sed_daily_suscon}},
  \code{\link{hy_sed_monthly_loads}},
  \code{\link{hy_sed_monthly_suscon}},
  \code{\link{hy_sed_samples_psd}},
  \code{\link{hy_sed_samples}}, \code{\link{hy_stations}},
  \code{\link{hy_stn_data_coll}},
  \code{\link{hy_stn_data_range}},
  \code{\link{hy_stn_op_schedule}},
  \code{\link{hy_version}}
}
