% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distinct_dt.R
\name{distinct_dt}
\alias{distinct_dt}
\title{Select distinct/unique rows in data.frame}
\usage{
distinct_dt(data, ..., .keep_all = FALSE)
}
\arguments{
\item{data}{data.frame}

\item{...}{Optional variables to use when determining uniqueness.
If there are multiple rows for a given combination of inputs,
only the first row will be preserved.
If omitted, will use all variables.}

\item{.keep_all}{If \code{TRUE}, keep all variables in data.frame. If a combination of ... is not distinct,
this keeps the first row of values.}
}
\value{
data.table
}
\description{
Analogous function for \code{distinct} in \pkg{dplyr}
}
\examples{
iris \%>\% distinct_dt()
iris \%>\% distinct_dt(Species)
iris \%>\% distinct_dt(Species,.keep_all = TRUE)
mtcars \%>\% distinct_dt(cyl,vs)
mtcars \%>\% distinct_dt(cyl,vs,.keep_all = TRUE)

}
\seealso{
\code{\link[dplyr]{distinct}}
}
