% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.pcr.R
\name{.fit.pcr}
\alias{.fit.pcr}
\title{Principal Components Regression for \code{tidyfit}}
\usage{
\method{.fit}{pcr}(self, data = NULL)
}
\arguments{
\item{self}{a 'tidyFit' R6 class.}

\item{data}{a data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}
}
\value{
A fitted 'tidyFit' class model.
}
\description{
Fits a principal components regression on a 'tidyFit' \code{R6} class. The function can be used with \code{\link{regress}}.
}
\details{
\strong{Hyperparameters:}
\itemize{
\item \code{ncomp} \emph{(number of components)}
\item \code{ncomp_pct} \emph{(number of components, percentage of features)}
}

\strong{Important method arguments (passed to \code{\link{m}})}

The principal components regression is fitted using \code{pls} package. See \code{?pcr} for more details.

\strong{Implementation}

Covariates are standardized, with coefficients back-transformed to the original scale. An intercept is always included.

If no hyperparameter grid is passed (\code{is.null(control$ncomp) & is.null(control$ncomp_pct)}), the default is \code{ncomp_pct = seq(0, 1, length.out = 20)}, where 0 results in one component and 1 results in the number of features.

When 'jackknife = TRUE' is passed (and a 'validation' method is chosen), \code{coef} also returns the jack-knife standard errors, t-statistics and p-values.

Note that at present \code{pls} does not offer weighted implementations or non-gaussian response. The method can therefore only be used with \code{\link{regress}}
}
\examples{
# Load data
data <- tidyfit::Factor_Industry_Returns
data <- dplyr::filter(data, Industry == "HiTec")
data <- dplyr::select(data, -Industry)

# Stand-alone function
fit <- m("pcr", Return ~ ., data, ncomp = 1:3)
fit

# Within 'regress' function
fit <- regress(data, Return ~ .,
               m("pcr", jackknife = TRUE, validation = "LOO", ncomp_pct = 0.5),
               .mask = c("Date"))
tidyr::unnest(coef(fit), model_info)

}
\references{
Liland K, Mevik B, Wehrens R (2022). \emph{pls: Partial Least Squares and Principal Component Regression}. R package version 2.8-1, \url{https://CRAN.R-project.org/package=pls}.
}
\seealso{
\code{\link{.fit.plsr}} and \code{\link{m}} methods
}
\author{
Johann Pfitzinger
}
