% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill.R
\name{dt_fill}
\alias{dt_fill}
\title{Fill with data.table}
\usage{
dt_fill(dt_, ..., id = NULL, .direction = c("down", "up", "downup", "updown"))
}
\arguments{
\item{dt_}{the data table (or if not a data.table then it is coerced with as.data.table)}

\item{...}{the columns to fill}

\item{id}{the grouping variable(s) to fill within}

\item{.direction}{either "down" or "up" (down fills values down, up fills values up), or "downup" (down first then up) or "updown" (up first then down)}
}
\value{
A data.table with listed columns having values filled in
}
\description{
Fills in values, similar to \code{tidyr::fill()}, by within \code{data.table}. This function relies on the
\code{Rcpp} functions that drive \code{tidyr::fill()} but applies them within \code{data.table}.
}
\examples{

set.seed(84322)
library(data.table)

x = 1:10
dt = data.table(v1 = x,
                v2 = shift(x),
                v3 = shift(x, -1L),
                v4 = sample(c(rep(NA, 10), x), 10),
                grp = sample(1:3, 10, replace = TRUE))
dt_fill(dt, v2, v3, v4, id = grp, .direction = "downup")
dt_fill(dt, v2, v3, v4, id = grp)
dt_fill(dt, .direction = "up")

}
