% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export_image}
\alias{export_image}
\title{Export the workflow plot as PNG, JPEG, or PDF files}
\usage{
export_image(file_html, file_image, ...)
}
\arguments{
\item{file_html}{File path to the HTML exported by \code{\link{export_html}}.}

\item{file_image}{File path to the output image.
Should end with \code{.png}, \code{.pdf}, or \code{.jpeg}.}

\item{...}{Additional parameters for \code{\link[webshot]{webshot}}.}
}
\value{
Image file path
}
\description{
Export the workflow plot as PNG, JPEG, or PDF files
}
\note{
This function uses \code{\link[webshot]{webshot}} to take
a screenshot for the rendered HTML of the graph.
It requires PhantomJS installed in your system.
You can use \code{\link[webshot]{install_phantomjs}} to install it.
}
\examples{
if (interactive()) {
  file_png <- tempfile(fileext = ".png")
  flow <- system.file("cwl/sbg/workflow/gatk4-wgs.json", package = "tidycwl") \%>\% read_cwl_json()
  get_graph(
    flow \%>\% parse_inputs(),
    flow \%>\% parse_outputs(),
    flow \%>\% parse_steps()
  ) \%>\%
    visualize_graph() \%>\%
    export_html(tempfile(fileext = ".html")) \%>\%
    export_image(file_png, vwidth = 2000, vheight = 3000, selector = "div.vis-network")
}
}
