% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation.R
\name{correlate}
\alias{correlate}
\title{Compute correlation coefficients}
\usage{
correlate(data, ..., method = "pearson", partial = NULL, with = NULL)
}
\arguments{
\item{data}{a \link[tibble:tibble-package]{tibble} or a \link{tdcmm} model}

\item{...}{Variables to compute correlations for (column names). Leave empty
to compute for all numeric variables in data.}

\item{method}{a character string indicating which correlation coefficient
is to be computed. One of "pearson" (default), "kendall", or "spearman"}

\item{partial}{Specifies a variable to be used as a control in a partial correlation.
By default, this parameter is set to \code{NULL}, indicating that no control variable
is used in the correlation. If used, \code{with} must be set to \code{NULL} (default).}

\item{with}{Specifies a focus variable to correlate all other variables with.
By default, this parameter is set to \code{NULL}, indicating that no focus variable
is used in the correlation. If used, \code{partial} must be set to \code{NULL} (default).}
}
\value{
a \link{tdcmm} model
}
\description{
Computes correlation coefficients for all combinations of the specified
variables. If no variables are specified, all numeric (integer or double)
variables are used.
}
\examples{
WoJ \%>\% correlate(ethics_1, ethics_2, ethics_3)
WoJ \%>\% correlate()
WoJ \%>\% correlate(ethics_1, ethics_2, ethics_3, with = work_experience)
WoJ \%>\% correlate(autonomy_selection, autonomy_emphasis, partial = work_experience)
WoJ \%>\% correlate(with = work_experience)

}
\concept{correlations}
