% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttest.R
\name{t_test}
\alias{t_test}
\title{Compute t-tests}
\usage{
t_test(
  data,
  group_var,
  ...,
  var.equal = TRUE,
  paired = FALSE,
  pooled_sd = TRUE,
  levels = NULL,
  case_var = NULL
)
}
\arguments{
\item{data}{a \link[tibble:tibble-package]{tibble}}

\item{group_var}{group variable (column name)}

\item{...}{test variables (column names). Leave empty to compute t-tests for
all numeric variables in data.}

\item{var.equal}{a logical variable indicating whether to treat the two
variances as being equal. If \code{TRUE} then the pooled variance is used to
estimate the variance otherwise the Welch (or Satterthwaite) approximation
to the degrees of freedom is used. Defaults to \code{TRUE}.}

\item{paired}{a logical indicating whether you want a paired t-test. Defaults
to \code{FALSE}.}

\item{pooled_sd}{a logical indicating whether to use the pooled standard
deviation in the calculation of Cohen's d. Defaults to \code{TRUE}.}

\item{levels}{optional: a vector of length two specifying the two levels of
the group variable.}

\item{case_var}{optional: case-identifying variable (column name). If you
set \code{paired = TRUE}, specifying a case variable will ensure that data
are properly sorted for a dependent t-test.}
}
\value{
a \link[tibble:tibble-package]{tibble}
}
\description{
Computes t-tests for one group variable and specified test variables.
If no variables are specified, all numeric (integer or double) variables are
used.
}
\examples{
WoJ \%>\% t_test(temp_contract, autonomy_selection, autonomy_emphasis)
WoJ \%>\% t_test(temp_contract)
WoJ \%>\% t_test(employment, autonomy_selection, autonomy_emphasis,
  levels = c("Full-time", "Freelancer"))

}
\concept{t-test}
